% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CheckInput.R
\name{CheckInput}
\alias{CheckInput}
\title{Main Check Input function}
\usage{
CheckInput(datatable, fixedrows = FALSE, gstandard = "No", maxits = 1000,
  tol = 1e-12, dplaces = 4, showall = FALSE)
}
\arguments{
\item{datatable}{Matrix. Expected to be square matrix with at least 2 rows (columns), non negative values and at least an element different of zero.}

\item{fixedrows}{Boolean. Indicate if sample rows are fixed beforehand. Default is TRUE.}

\item{gstandard}{Text. Indicate if there are a Gold Standard by Rows or columns. Only first letter matter without Case sensitivity. Options are: "N" for None, "R" for in Rows and "C" for in Columns. Default is "N".}

\item{maxits}{Whole number. Indicate the maximum number of iterations of the numeric method to calculate B. Expected to be 100 <= maxits <= 5000. Default is 1000.}

\item{tol}{Double number. Indicate the precision of the numeric method to calculate B. Expected to be 1e-6 <= tol <= 1e-15.Default is 1e-12.}

\item{dplaces}{Whole number. Decimal placed to be shown in the result. Expected to be 1 <= dplaces <0 6. Default 4.}

\item{showall}{Boolean. Indicate if all output should be shown. If TRUE also shown hidden results. If FALSE shown only main output. By default is FALSE.}
}
\description{
This function perform multiple tasks. First of all, check the parameters specified by the user.  Also asign default values to some parameters not defined by the user. Finally it generates error  messages and halt the execution in case it is needed.
}
\examples{
CheckInput(matrix(c(1,2,3,4),2,2),fixedrows=FALSE,gstandard="No",maxits=100,tol=1e-12,dplaces=4)
}
\keyword{check}
\keyword{datatable}
\keyword{dplaces}
\keyword{fixedrows}
\keyword{gstandard}
\keyword{maxits}
\keyword{tol}
