% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binary_iv_designer.R
\name{binary_iv_designer}
\alias{binary_iv_designer}
\alias{simple_iv_designer}
\title{Create a binary instrumental variables design}
\usage{
binary_iv_designer(N = 100, type_probs = c(1/3, 1/3, 1/3, 0),
  assignment_probs = c(0.5, 0.5, 0.5, 0.5), a_Y = 1, b_Y = 0,
  d_Y = 0, outcome_sd = 1, a = c(1, 0, 0, 0) * a_Y, b = rep(b_Y,
  4), d = rep(d_Y, 4))
}
\arguments{
\item{N}{An integer. Sample size.}

\item{type_probs}{A vector of four numbers in [0,1]. Probability of each complier type (always-taker, never-taker, complier, defier).}

\item{assignment_probs}{A vector of four numbers in [0,1]. Probability of assignment to encouragement (Z) for each complier type (always-taker, never-taker, complier, defier). Under random assignment these are normally identical since complier status is not known to researchers in advance.}

\item{a_Y}{A real number. Constant in Y equation. Assumed constant across types. Overridden by \code{a} if specified.}

\item{b_Y}{A real number. Effect of X on Y equation. Assumed constant across types. Overridden by \code{b} if specified.}

\item{d_Y}{A real number. Effect of Z on Y. Assumed constant across types. Overridden by \code{d} if specified.}

\item{outcome_sd}{A non negative number. Standard deviation on Y.}

\item{a}{A vector of four numbers. Constant in Y equation for each complier type (always-taker, never-taker, complier, defier).}

\item{b}{A vector of four numbers. Slope on X in Y equation for each complier type (always-taker, never-taker, complier, defier).}

\item{d}{A vector of four numbers. Slope on Z in Y equation for each complier type (non zero implies violation of exclusion restriction).}
}
\value{
A simple instrumental variables design.
}
\description{
Builds a design with one instrument, one binary explanatory variable, and one outcome.
}
\details{
A researcher is interested in the effect of binary X on outcome Y.  The relationship is confounded  because units that are more likely to be assigned to X=1 have higher Y outcomes.
A potential instrument Z is examined, which plausibly causes X. The instrument can be used to assess the effect of X on Y for units whose value of X depends on Z if Z does not negatively affect X for some cases, affects X positively for some, and affects Y only through X.
}
\examples{
# Generate a simple iv design: iv identifies late not ate 
binary_iv_design_1 <- binary_iv_designer(N = 1000, b = c(.1, .2, .3, .4))
\dontrun{
diagnose_design(binary_iv_design_1)
}

# Generates a simple iv design with violation of monotonicity
binary_iv_design_2 <- binary_iv_designer(type_probs = c(.1,.1,.6, .2), b_Y = .5)
\dontrun{
diagnose_design(binary_iv_design_2)
}

# Generates a simple iv design with violation of exclusion restriction
binary_iv_design_3 <- binary_iv_designer(d_Y = .5, b_Y = .5)
\dontrun{
diagnose_design(binary_iv_design_3)
}

# Generates a simple iv design with violation of randomization
binary_iv_design_4 <- binary_iv_designer(N = 1000, assignment_probs = c(.2, .3, .7, .5), b_Y = .5)
\dontrun{
diagnose_design(binary_iv_design_4)
}

# Generates a simple iv design with violation of first stage
binary_iv_design_5 <- binary_iv_designer(type_probs = c(.5,.5, 0, 0), b_Y = .5)
\dontrun{
diagnose_design(binary_iv_design_5)
}

}
\author{
\href{https://declaredesign.org/}{DeclareDesign Team}
}
\concept{experiment}
