% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peelingTwoIterate.R
\name{peelingTwoIterate}
\alias{peelingTwoIterate}
\title{A Function to Apply the Peeling Algorithm for Two Copy Number Matrices}
\usage{
peelingTwoIterate(
  X,
  Y,
  posDT,
  gain = TRUE,
  nullDist = NULL,
  threshold = NULL,
  numIters = 5
)
}
\arguments{
\item{X}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{Y}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{posDT}{A data frame containing genomic position information for the genes in X.}

\item{gain}{A logical value indicating whether gains (TRUE) or losses (FALSE) will be peeled.

Default = TRUE.}

\item{nullDist}{An empirical null distribution produced by the cyclic shift algorithm.

Default = NULL.}

\item{threshold}{A tuning parameter that controls the size of the peeled region.  Rows of X

and Y with mean copy number differences less than threshold will not be peeled.  Default = NULL.}

\item{numIters}{The number of times peelingTwo will be iterated.  Default = 5.}
}
\value{
A list containing two elements: X, Y, and interval.  X and Y are updated versions of the input
copy number matrices in which the peak difference at k has been removed, and interval is genomic region
containing k.  By construction, interval cannot extend beyond the chromosome arm containing k.
}
\description{
This function iteratively applies the peelingTwo function, thereby identifying multiple
}
\details{
differences across the genome between a two cohorts.  Gains and losses should be analyzed separately.
}
\examples{
luad=pD[["X"]]

 lusc=pD[["Y"]]

 posDT=pD[["posDT"]]

 gain = TRUE

 nullDist = NULL

 threshold = NULL

 numIters = 3

 out=peelingTwoIterate(X=luad,Y=lusc,posDT=posDT,gain=TRUE,nullDist=NULL,threshold=NULL,numIters=3)   

}
