% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_edge_attr_in_selection.R
\name{rescale_edge_attr_in_selection}
\alias{rescale_edge_attr_in_selection}
\title{Rescale numeric edge attribute values for edges in a selection}
\usage{
rescale_edge_attr_in_selection(graph, edge_attr_from, edge_attr_to,
  to_lower_bound = 0, to_upper_bound = 1, from_lower_bound = NULL,
  from_upper_bound = NULL)
}
\arguments{
\item{graph}{a graph object of class \code{dgr_graph} that is created using
\code{create_graph}.}

\item{edge_attr_from}{the edge attribute containing numeric data that
is to be rescaled to new numeric or color values.}

\item{edge_attr_to}{the name of the new or existing edge attribute that
will contain the scaled values. If the edge attribute exists for the
selected edges, rescaled values will replace any existing values.}

\item{to_lower_bound}{the lower bound value for the set of rescaled
values. This can be a numeric value or an X11 color name.}

\item{to_upper_bound}{the upper bound value for the set of rescaled
values. This can be a numeric value or an X11 color name.}

\item{from_lower_bound}{an optional, manually set lower bound value for
the set of values to be rescaled. If not set, the minimum value of the set of
values to be rescaled will be used.}

\item{from_upper_bound}{an optional, manually set upper bound value for
the set of values to be rescaled. If not set, the minimum value of the set of
values to be rescaled will be used.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class \code{dgr_graph}, take a set of
numeric values for edge attributes specified in a selection of edges,
rescale to a new numeric or color range, then write a new set of edge
attribute values.
}

