% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/display_graph_object.R
\name{display_graph_object}
\alias{display_graph_object}
\title{Update and display graph object}
\usage{
display_graph_object(graph, width = 400)
}
\arguments{
\item{graph}{a \code{dgr_graph} object, created using the
\code{create_graph} function.}

\item{width}{the width of the graph representation in pixels.}
}
\description{
Using a \code{dgr_graph} object, update values of counts for
nodes, edges, attributes, directed state, and display the schematic in the
RStudio Viewer.
}
\examples{
\dontrun{
Create a simple graph and display a visual summary
of simple graph properties
nodes <-
  create_nodes(nodes = c("a", "b", "c", "d"),
               label = FALSE,
               type = "letter")

edges <-
  create_edges(from = c("a", "b", "c"),
               to = c("d", "c", "a"),
               rel = "connected_to")

graph <- create_graph(nodes_df = nodes,
                      edges_df = edges)

display_graph_object(graph, width = 640)
}
}

