% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache_node_attrs.R
\name{cache_node_attrs}
\alias{cache_node_attrs}
\title{Cache node attributes in the graph}
\usage{
cache_node_attrs(graph, node_attr, mode = NULL, nodes = NULL)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr}{the node attribute from which to
obtain values.}

\item{mode}{a option to recast the returned vector
of node attribute value as \code{numeric} or
\code{character}.}

\item{nodes}{an optional vector of node IDs for
filtering the list of nodes present in the graph.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
From a graph object of class
\code{dgr_graph}, get node attribute properties for
one or more nodes and cache those values in the
graph for later retrieval using \code{get_cache}.
}
\examples{
# Set a seed
set.seed(25)

# Create a graph with 10 nodes and 9 edges
graph <-
  create_graph() \%>\%
  add_n_nodes(10) \%>\%
  set_node_attrs(
    "value", rnorm(node_count(.), 5, 2)) \%>\%
  add_edges_w_string(
    "1->2 1->3 2->4 2->5 3->6
     3->7 4->8 4->9 5->10")

# Cache all values from the node attribute `value`
# as a numeric vector
graph <-
  graph \%>\%
  cache_node_attrs("value", "numeric")

# Get the mean from all values available in
# the cache
graph \%>\% get_cache() \%>\% mean()
#> [1] 4.651246
}

