% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_bridging.R
\name{get_bridging}
\alias{get_bridging}
\title{Get bridging scores}
\usage{
get_bridging(graph)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}
}
\value{
a data frame with bridging scores for
each of the nodes.
}
\description{
Get the bridging scores (based on
Valente's Bridging vertex measure) for all nodes
in a graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    10, 22, set_seed = 1)

# Get the bridging scores for nodes
# in the graph
get_bridging(graph)
#>    id    bridging
#> 1   1 0.006944444
#> 2   2 0.006296296
#> 3   3 0.006018519
#> 4   4 0.006944444
#> 5   5 0.005555556
#> 6   6 0.006790123
#> 7   7 0.006790123
#> 8   8 0.006666667
#> 9   9 0.005555556
#> 10 10 0.006790123
}

