% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_node_attrs.R
\name{rename_node_attrs}
\alias{rename_node_attrs}
\title{Rename a node attribute}
\usage{
rename_node_attrs(graph, node_attr_from, node_attr_to)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{node_attr_from}{the name of the node attribute
that will be renamed.}

\item{node_attr_to}{the new name of the node
attribute column identified in \code{node_attr_from}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal node data
frame (ndf), rename an existing node attribute.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    5, 10, set_seed = 3) \%>\%
  set_node_attrs("shape", "circle")

# Get the graph's internal ndf to show which
# node attributes are available
get_node_df(graph)
#>   id type label value  shape
#> 1  1 <NA>     1   2.0 circle
#> 2  2 <NA>     2   8.5 circle
#> 3  3 <NA>     3   4.0 circle
#> 4  4 <NA>     4   3.5 circle
#> 5  5 <NA>     5   6.5 circle

# Rename the `value` node attribute as `weight`
graph <-
  graph \%>\%
  rename_node_attrs("value", "weight")

# Get the graph's internal ndf to show that the
# node attribute had been renamed
get_node_df(graph)
#>   id type label weight  shape
#> 1  1 <NA>     1    2.0 circle
#> 2  2 <NA>     2    8.5 circle
#> 3  3 <NA>     3    4.0 circle
#> 4  4 <NA>     4    3.5 circle
#> 5  5 <NA>     5    6.5 circle
}

