% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_series.R
\name{create_series}
\alias{create_series}
\title{Create a graph series object}
\usage{
create_series(graph = NULL, series_name = NULL,
  series_type = "sequential")
}
\arguments{
\item{graph}{a graph object to add to the new
graph series object.}

\item{series_name}{an optional name to ascribe to
the series.}

\item{series_type}{either a \code{sequential} type
(the default) or a \code{temporal} type (which
requires date-time strings and time zone codes
to be supplied).}
}
\value{
a graph series object of type
\code{dgr_graph_1D}.
}
\description{
Create a graph series object for the
storage of multiple graphs across a sequential or
temporal one-dimensional array.
}
\examples{
# Create three graphs
graph_1 <-
  create_graph() \%>\%
  add_n_nodes(n = 3) \%>\%
  add_edges_w_string(
    edges = "1->3 1->2 2->3")

graph_2 <-
  graph_1 \%>\%
  add_node() \%>\%
  add_edge(
    from = 4,
    to = 3)

graph_3 <-
  graph_2 \%>\%
  add_node() \%>\%
  add_edge(
    from = 5,
    to = 2)

# Create an empty graph series and add
# the graphs
series <-
  create_series() \%>\%
  add_to_series(graph_1, .) \%>\%
  add_to_series(graph_2, .) \%>\%
  add_to_series(graph_3, .)

# Count the number of graphs in the graph series
graph_count(series)
#> [1] 3
}
