% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pagerank.R
\name{get_pagerank}
\alias{get_pagerank}
\title{Get the PageRank values for nodes in the graph}
\usage{
get_pagerank(graph, directed = TRUE, damping = 0.85)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{directed}{if \code{TRUE} (the default)
then directed paths will be considered for
directed graphs. This is ignored for undirected
graphs.}

\item{damping}{the damping factor. The default
value is set to \code{0.85}.}
}
\value{
a data frame with PageRank values for
each of the nodes.
}
\description{
Get the PageRank values for
all nodes in the graph.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 10, m = 22,
    set_seed = 23)

# Get the alpha centrality scores for nodes
# in the graph
get_pagerank(graph)
#>    id   pagerank
#> 1   1 0.04608804
#> 2   2 0.04608804
#> 3   3 0.05392301
#> 4   4 0.04608804
#> 5   5 0.07677500
#> 6   6 0.11684759
#> 7   7 0.07899491
#> 8   8 0.08898857
#> 9   9 0.16945368
#> 10 10 0.27675311

# Colorize nodes according to their
# PageRank scores
graph <-
  graph \%>\%
  join_node_attrs(
    df = get_pagerank(graph = .)) \%>\%
  colorize_node_attrs(
    node_attr_from = pagerank,
    node_attr_to = fillcolor,
    palette = "RdYlGn")
}
