% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_edge_attrs.R
\name{rename_edge_attrs}
\alias{rename_edge_attrs}
\title{Rename an edge attribute}
\usage{
rename_edge_attrs(graph, edge_attr_from, edge_attr_to)
}
\arguments{
\item{graph}{a graph object of class
\code{dgr_graph}.}

\item{edge_attr_from}{the name of the edge attribute
that will be renamed.}

\item{edge_attr_to}{the new name of the edge
attribute column identified in \code{edge_attr_from}.}
}
\value{
a graph object of class \code{dgr_graph}.
}
\description{
Within a graph's internal edge data
frame (edf), rename an existing edge attribute.
}
\examples{
# Create a random graph
graph <-
  create_random_graph(
    n = 5, m = 8,
    set_seed = 23) \%>\%
  set_edge_attrs(
    edge_attr = color,
    values = "green")

# Get the graph's internal edf
# to show which edge attributes
# are available
get_edge_df(graph)
#>   id from to  rel color
#> 1  1    2  3 <NA> green
#> 2  2    3  5 <NA> green
#> 3  3    3  4 <NA> green
#> 4  4    2  4 <NA> green
#> 5  5    2  5 <NA> green
#> 6  6    4  5 <NA> green
#> 7  7    1  4 <NA> green
#> 8  8    1  3 <NA> green

# Rename the `value` node
# attribute as `weight`
graph <-
  graph \%>\%
  rename_edge_attrs(
    edge_attr_from = color,
    edge_attr_to = labelfontcolor)

# Get the graph's internal
# edf to show that the edge
# attribute had been renamed
get_edge_df(graph)
#>   id from to  rel labelfontcolor
#> 1  1    2  3 <NA>          green
#> 2  2    3  5 <NA>          green
#> 3  3    3  4 <NA>          green
#> 4  4    2  4 <NA>          green
#> 5  5    2  5 <NA>          green
#> 6  6    4  5 <NA>          green
#> 7  7    1  4 <NA>          green
#> 8  8    1  3 <NA>          green
}
