% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_node_ids.R
\name{get_node_ids}
\alias{get_node_ids}
\title{Get a vector of node ID values}
\usage{
get_node_ids(graph, conditions = NULL)
}
\arguments{
\item{graph}{a graph object of
class \code{dgr_graph}.}

\item{conditions}{an option to
use filtering conditions for the
retrieval of nodes.}
}
\value{
a vector of node ID
values.
}
\description{
Obtain a vector of
node ID values from a graph
object. An optional filter by
node attribute can limit the set
of node ID values returned.
}
\examples{
# Create a node data
# frame (ndf)
ndf <-
  create_node_df(
    n = 4,
    type = "letter",
    color = c(
      "red", "green",
      "blue", "blue"),
    value = c(
      3.5, 2.6, 9.4, 2.7))

# Create a graph using
# the ndf
graph <-
  create_graph(
    nodes_df = ndf)

# Get a vector of all nodes in a graph
graph \%>\%
  get_node_ids()

# Get a vector of node ID values using a
# numeric comparison (i.e., all nodes with
# `value` attribute greater than 3)
graph \%>\%
  get_node_ids(
    conditions = value > 3)

# Get a vector of node ID values using
# a match pattern (i.e., all nodes with
# `color` attribute of `green`)
graph \%>\%
  get_node_ids(
    conditions = color == "green")

# Use multiple conditions to return nodes
# with the desired attribute values
graph \%>\%
  get_node_ids(
    conditions =
      color == "blue" &
      value > 5)
}
