% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_edge_df.R
\name{add_edge_df}
\alias{add_edge_df}
\title{Add edges from an edge data frame to an existing graph object}
\usage{
add_edge_df(graph, edge_df)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{edge_df}{An edge data frame that is created using \code{\link[=create_edge_df]{create_edge_df()}}.}
}
\value{
A graph object of class \code{dgr_graph}.
}
\description{
With a graph object of class \code{dgr_graph}, add edges from an edge data frame
to that graph.
}
\examples{
# Create a graph with 4 nodes
# and no edges
graph <-
  create_graph() \%>\%
  add_n_nodes(n = 4)

# Create an edge data frame (edf)
edf <-
  create_edge_df(
    from = c(1, 2, 3),
      to = c(4, 3, 1))

# Add the edge data frame to
# the graph object to create
# a graph with both nodes
# and edges
graph <-
  graph \%>\%
  add_edge_df(
    edge_df = edf)

# Get the graph's edges to
# verify that the edf had
# been added
graph \%>\%
  get_edges(
    return_type = "vector")
}
