% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/delete_cache.R
\name{delete_cache}
\alias{delete_cache}
\title{Delete vectors cached in a graph object}
\usage{
delete_cache(graph, name = NULL)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{name}{One or more name of vector objects to delete from the cache. If
none supplied, all cached vectors available in the graph will be deleted.}
}
\value{
A vector.
}
\description{
Delete vectors cached in a graph object of class \code{dgr_graph}.
}
\examples{
# Create an empty graph
graph <-
  create_graph()

# Cache 3 different vectors inside
# the graph object
graph <-
  graph \%>\%
  set_cache(
    name = "a",
    to_cache = 1:4) \%>\%
  set_cache(
    name = "b",
    to_cache = 5:9) \%>\%
  set_cache(
    name = "c",
    to_cache = 10:14)

# Delete cache `b`
graph <-
  graph \%>\%
  delete_cache(name = "b")

# Delete remaining cached vectors
graph <-
  graph \%>\%
  delete_cache()
}
