% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dice_similarity.R
\name{get_dice_similarity}
\alias{get_dice_similarity}
\title{Get Dice similarity coefficient scores}
\usage{
get_dice_similarity(graph, nodes = NULL, direction = "all", round_to = 3)
}
\arguments{
\item{graph}{A graph object of class \code{dgr_graph}.}

\item{nodes}{an optional vector of node IDs to consider for Dice similarity
scores. If not supplied, then similarity scores will be provided for every
pair of nodes in the graph.}

\item{direction}{using \code{all} (the default), the function will ignore
edge direction when determining scores for neighboring nodes. With
\code{out} and \verb{in}, edge direction for neighboring nodes will be
considered.}

\item{round_to}{the maximum number of decimal places to retain for the Dice
similarity coefficient scores. The default value is \code{3}.}
}
\value{
A matrix with Dice similarity values for each pair of nodes
considered.
}
\description{
Get the Dice similarity coefficient scores for one or more nodes in a graph.
}
\examples{
# Create a random graph using the
# `add_gnm_graph()` function
graph <-
  create_graph(
    directed = FALSE) \%>\%
  add_gnm_graph(
    n = 10,
    m = 15,
    set_seed = 23)

# Get the Dice similarity
# values for nodes `5`, `6`,
# and `7`
graph \%>\%
  get_dice_similarity(
    nodes = 5:7)

}
