#' Long summarized disaggregated data set
#'
#' Sample data downloaded from the California Community College's Chancellor's Office Student Success Metrics dashboard.
#' @format A data frame with summarized data:
#' \describe{
#'   \item{value}{Success count (numerator).}
#'   \item{denom}{Group size (denominator).}
#'   \item{categoryLabel}{Metric or outcome.}
#'   \item{academicYear}{Academic year for given data.}
#'   \item{disagg1}{Different levels of disaggregation.}
#'   \item{subgroup1}{Groups corresponding to each disaggregation in \code{disagg1}.}
#'   \item{disagg2}{Second level of disaggregation: 'None' or 'Gender'.}
#'   \item{subgroup2}{Groups corresponding to each disaggregation in \code{disagg2}.}
#'   \item{cohort}{Not actually a cohort, but the time-window for the outcome in \code{categoryLabel}.}
#'   \item{localeName}{College name.}
#'   \item{metricID}{ID for current metric.}
#'   \item{title}{Title of visualization.}
#'   \item{categoryID}{ID for \code{categoryLabel}.}
#'   \item{perc}{\code{value / denom}.}
#'   \item{dataType}{All are 'Percent'.}
#'   \item{missingFlag}{1 if missing.}
#'   \item{ferpaFlag}{1 if FERPA-suppressed.}
#'   \item{X20}{Ignore.}
#'   \item{description}{Ignore.}
#'   \item{source}{Ignore.}
#' }
#' @docType data
#' 
#' @usage data(ssm_cohort)
#'
#' @keywords datasets
#'
#' @examples
#' data(ssm_cohort)
"ssm_cohort"
