% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/erlang.R
\name{erlang}
\alias{erlang}
\alias{dErlang}
\alias{pErlang}
\alias{expValErlang}
\alias{varErlang}
\alias{kthMomentErlang}
\alias{expValLimErlang}
\alias{expValTruncErlang}
\alias{stopLossErlang}
\alias{meanExcessErlang}
\alias{VatRErlang}
\alias{TVatRErlang}
\alias{mgfErlang}
\title{Erlang Distribution}
\usage{
dErlang(x, shape, rate = 1/scale, scale = 1/rate)

pErlang(q, shape, rate = 1/scale, scale = 1/rate, lower.tail = TRUE)

expValErlang(shape, rate = 1/scale, scale = 1/rate)

varErlang(shape, rate = 1/scale, scale = 1/rate)

kthMomentErlang(k, shape, rate = 1/scale, scale = 1/rate)

expValLimErlang(d, shape, rate = 1/scale, scale = 1/rate)

expValTruncErlang(d, shape, rate = 1/scale, scale = 1/rate, less.than.d = TRUE)

stopLossErlang(d, shape, rate = 1/scale, scale = 1/rate)

meanExcessErlang(d, shape, rate = 1/scale, scale = 1/rate)

VatRErlang(kap, shape, rate = 1/scale, scale = 1/rate)

TVatRErlang(kap, shape, rate = 1/scale, scale = 1/rate)

mgfErlang(t, shape, rate = 1/scale, scale = 1/rate)
}
\arguments{
\item{x}{vector of quantiles.}

\item{shape}{shape parameter \eqn{n}{n}, must be a positive integer.}

\item{rate}{rate parameter \eqn{\beta}{beta}, must be positive.}

\item{scale}{alternative parameterization to the rate parameter, scale = 1 / rate.}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are
    \eqn{P[X \le x]}, otherwise, \eqn{P[X > x]}.}

\item{k}{kth-moment.}

\item{d}{cut-off value.}

\item{less.than.d}{logical; if \code{TRUE} (default) truncated mean for values <= d, otherwise, for values > d.}

\item{kap}{probability.}

\item{t}{t.}
}
\value{
Function :
 \itemize{
 \item{\code{\link{dErlang}}}{ gives the probability density function (PDF).}
 \item{\code{\link{pErlang}}}{ gives the cumulative density function (CDF).}
 \item{\code{\link{expValErlang}}}{ gives the expected value.}
 \item{\code{\link{varErlang}}}{ gives the variance.}
 \item{\code{\link{kthMomentErlang}}}{ gives the kth moment.}
 \item{\code{\link{expValLimErlang}}}{ gives the limited mean.}
 \item{\code{\link{expValTruncErlang}}}{ gives the truncated mean.}
 \item{\code{\link{stopLossErlang}}}{ gives the stop-loss.}
 \item{\code{\link{meanExcessErlang}}}{ gives the mean excess loss.}
 \item{\code{\link{VatRErlang}}}{ gives the Value-at-Risk.}
 \item{\code{\link{TVatRErlang}}}{ gives the Tail Value-at-Risk.}
 \item{\code{\link{mgfErlang}}}{ gives the moment generating function (MGF).}
 }
 Invalid parameter values will return an error detailing which parameter is problematic.
}
\description{
Erlang distribution with shape parameter \eqn{n} and rate parameter
\eqn{\beta}{beta}.
}
\details{
The Erlang distribution with shape parameter \eqn{n} and rate parameter
\eqn{\beta}{b} has density:
  \deqn{f\left(x\right) = \frac{\beta^{n}}{\Gamma(n)} x^{n - 1}%
  \mathrm{e}^{-\beta x}}{f(x) = b^n / \Gamma(n) x^{n - 1} e^{-b x}}
for \eqn{x \in \mathcal{R}^+}{x > 0}, \eqn{\beta > 0}{b > 0},%
\eqn{n \in \mathcal{N}^+}{n = 1, 2, 3, ...}.
}
\note{
Function VatRErlang is a wrapper of the \code{\link[stats]{qgamma}}
function from the stats package.
}
\examples{
dErlang(x = 2, shape = 2, scale = 4)

pErlang(q = 2, shape = 2, scale = 4)

expValErlang(shape = 2, scale = 4)

varErlang(shape = 2, scale = 4)

kthMomentErlang(k = 3, shape = 2, scale = 4)

expValLimErlang(d = 2, shape = 2, scale = 4)

# With rate parameter
expValTruncErlang(d = 2, shape = 2, scale = 4)

# Values greater than d
expValTruncErlang(d = 2, shape = 2, scale = 4, less.than.d = FALSE)

stopLossErlang(d = 2, shape = 2, scale = 4)

meanExcessErlang(d = 3, shape = 2, scale = 4)

# With scale parameter
VatRErlang(kap = .2, shape = 2, scale = 4)

# With rate parameter
VatRErlang(kap = .2, shape = 2, rate = 0.25)

# With scale parameter
TVatRErlang(kap = .2, shape = 3, scale = 4)

# With rate parameter
TVatRErlang(kap = .2, shape = 3, rate = 0.25)

mgfErlang(t = 2, shape = 2, scale = .25)

}
