% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/double_ml_plr.R
\name{DoubleMLPLR}
\alias{DoubleMLPLR}
\title{Double machine learning for partially linear regression models}
\format{
\link[R6:R6Class]{R6::R6Class} object inheriting from \link{DoubleML}.
}
\description{
Double machine learning for partially linear regression models.
}
\details{
Partially linear regression (PLR) models take the form

\eqn{Y = D\theta_0 + g_0(X) + \zeta,}

\eqn{D = m_0(X) + V,}

with \eqn{E[\zeta|D,X]=0} and \eqn{E[V|X] = 0}. \eqn{Y} is the outcome variable variable and \eqn{D} is the policy variable of interest. The high-dimensional vector \eqn{X = (X_1, \ldots, X_p)} consists of other confounding covariates, and \eqn{\zeta} and \eqn{V} are stochastic errors.
}
\examples{
\donttest{
library(DoubleML)
library(mlr3)
library(mlr3learners)
library(data.table)
set.seed(2)
ml_g = lrn("regr.ranger", num.trees = 10, max.depth = 2)
ml_m = ml_g$clone()
obj_dml_data = make_plr_CCDDHNR2018(alpha = 0.5)
dml_plr_obj = DoubleMLPLR$new(obj_dml_data, ml_g, ml_m)
dml_plr_obj$fit()
dml_plr_obj$summary()
}

\dontrun{
library(DoubleML)
library(mlr3)
library(mlr3learners)
library(mlr3tuning)
library(data.table)
set.seed(2)
ml_g = lrn("regr.rpart")
ml_m = ml_g$clone()
obj_dml_data = make_plr_CCDDHNR2018(alpha = 0.5)
dml_plr_obj = DoubleMLPLR$new(obj_dml_data, ml_g, ml_m)

param_grid = list("ml_g" = paradox::ParamSet$new(
                     list(paradox::ParamDbl$new("cp", lower = 0.01, upper = 0.02),
                          paradox::ParamInt$new("minsplit", lower = 1, upper = 2))),
                 "ml_m" = paradox::ParamSet$new(
                     list(paradox::ParamDbl$new("cp", lower = 0.01, upper = 0.02),
                          paradox::ParamInt$new("minsplit", lower = 1, upper = 2))))

# minimum requirements for tune_settings
tune_settings = list(terminator = mlr3tuning::trm("evals", n_evals = 5), 
                      algorithm = mlr3tuning::tnr("grid_search", resolution = 5))
dml_plr_obj$tune(param_set = param_grid, tune_settings = tune_settings)
dml_plr_obj$fit()
dml_plr_obj$summary()
}
}
\seealso{
Other DoubleML: 
\code{\link{DoubleMLIIVM}},
\code{\link{DoubleMLIRM}},
\code{\link{DoubleMLPLIV}},
\code{\link{DoubleML}}
}
\concept{DoubleML}
\section{Super class}{
\code{\link[DoubleML:DoubleML]{DoubleML::DoubleML}} -> \code{DoubleMLPLR}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{DoubleMLPLR$new()}}
\item \href{#method-clone}{\code{DoubleMLPLR$clone()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="bootstrap">}\href{../../DoubleML/html/DoubleML.html#method-bootstrap}{\code{DoubleML::DoubleML$bootstrap()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="confint">}\href{../../DoubleML/html/DoubleML.html#method-confint}{\code{DoubleML::DoubleML$confint()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="fit">}\href{../../DoubleML/html/DoubleML.html#method-fit}{\code{DoubleML::DoubleML$fit()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="get_params">}\href{../../DoubleML/html/DoubleML.html#method-get_params}{\code{DoubleML::DoubleML$get_params()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="learner_names">}\href{../../DoubleML/html/DoubleML.html#method-learner_names}{\code{DoubleML::DoubleML$learner_names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="p_adjust">}\href{../../DoubleML/html/DoubleML.html#method-p_adjust}{\code{DoubleML::DoubleML$p_adjust()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="params_names">}\href{../../DoubleML/html/DoubleML.html#method-params_names}{\code{DoubleML::DoubleML$params_names()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="print">}\href{../../DoubleML/html/DoubleML.html#method-print}{\code{DoubleML::DoubleML$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="set_ml_nuisance_params">}\href{../../DoubleML/html/DoubleML.html#method-set_ml_nuisance_params}{\code{DoubleML::DoubleML$set_ml_nuisance_params()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="set_sample_splitting">}\href{../../DoubleML/html/DoubleML.html#method-set_sample_splitting}{\code{DoubleML::DoubleML$set_sample_splitting()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="split_samples">}\href{../../DoubleML/html/DoubleML.html#method-split_samples}{\code{DoubleML::DoubleML$split_samples()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="summary">}\href{../../DoubleML/html/DoubleML.html#method-summary}{\code{DoubleML::DoubleML$summary()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="DoubleML" data-topic="DoubleML" data-id="tune">}\href{../../DoubleML/html/DoubleML.html#method-tune}{\code{DoubleML::DoubleML$tune()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this R6 class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleMLPLR$new(
  data,
  ml_g,
  ml_m,
  n_folds = 5,
  n_rep = 1,
  score = "partialling out",
  dml_procedure = "dml2",
  draw_sample_splitting = TRUE,
  apply_cross_fitting = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{(\code{DoubleMLData}) \cr
The \code{DoubleMLData} object providing the data and specifying the variables of the causal model.}

\item{\code{ml_g}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}}, \code{character(1)},) \cr
An object of the class \link[mlr3:LearnerRegr]{mlr3 regression learner} to pass a learner, possibly with specified parameters, for example \code{lrn("regr.cv_glmnet", s = "lambda.min")}.
Alternatively, a \code{character(1)} specifying the name of a \link[mlr3:LearnerRegr]{mlr3 regression learner} that is available in \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or \href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}, for example \code{"regr.cv_glmnet"}. \cr
\code{ml_g} refers to the nuisance function \eqn{g_0(X) = E[Y|X]}.}

\item{\code{ml_m}}{(\code{\link[mlr3:LearnerRegr]{LearnerRegr}}, \code{\link[mlr3:LearnerClassif]{LearnerClassif}}, \code{character(1)},) \cr
An object of the class \link[mlr3:LearnerRegr]{mlr3 regression learner} to pass a learner, possibly with specified parameters, for example \code{lrn("regr.cv_glmnet", s = "lambda.min")}. For binary treatment variables, an object of the class \code{\link[mlr3:LearnerClassif]{LearnerClassif}} can be passed, for example \code{lrn("classif.cv_glmnet", s = "lambda.min")}. Alternatively, a \code{character(1)} specifying the name of a \link[mlr3:LearnerRegr]{mlr3 regression learner} that is available in \href{https://mlr3.mlr-org.com/index.html}{mlr3} or its extension packages \href{https://mlr3learners.mlr-org.com/}{mlr3learners} or \href{https://mlr3extralearners.mlr-org.com/}{mlr3extralearners}, for example \code{"regr.cv_glmnet"}. \cr
\code{ml_m} refers to the nuisance function \eqn{m_0(X) = E[D|X]}.}

\item{\code{n_folds}}{(\code{integer(1)})\cr
Number of folds. Default is \code{5}.}

\item{\code{n_rep}}{(\code{integer(1)}) \cr
Number of repetitions for the sample splitting. Default is \code{1}.}

\item{\code{score}}{(\code{character(1)}, \verb{function()}) \cr
A \code{character(1)} (\code{"partialling out"} or \code{IV-type}) or a \verb{function()} specifying the score function.
If a \verb{function()} is provided, it must be of the form \verb{function(y, d, g_hat, m_hat, smpls)} and
the returned output must be a named \code{list()} with elements \code{psi_a} and \code{psi_b}. Default is \code{"partialling out"}.}

\item{\code{dml_procedure}}{(\code{character(1)}) \cr
A \code{character(1)} (\code{"dml1"} or \code{"dml2"}) specifying the double machine learning algorithm. Default is \code{"dml2"}.}

\item{\code{draw_sample_splitting}}{(\code{logical(1)}) \cr
Indicates whether the sample splitting should be drawn during initialization of the object. Default is \code{TRUE}.}

\item{\code{apply_cross_fitting}}{(\code{logical(1)}) \cr
Indicates whether cross-fitting should be applied. Default is \code{TRUE}.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DoubleMLPLR$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
