% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/AdjustedVarianceCovarianceVaR.R
\name{AdjustedVarianceCovarianceVaR}
\alias{AdjustedVarianceCovarianceVaR}
\title{Cornish-Fisher adjusted variance-covariance VaR}
\usage{
AdjustedVarianceCovarianceVaR(vc.matrix, mu, skew, kurtosis, positions, cl, hp)
}
\arguments{
\item{vc.matrix}{Assumed variance covariance matrix for returns}

\item{mu}{Vector of expected position returns}

\item{skew}{Portfolio return skewness}

\item{kurtosis}{Portfolio return kurtosis}

\item{positions}{Vector of positions}

\item{cl}{Confidence level and is scalar or vector}

\item{hp}{Holding period and is scalar or vector}
}
\description{
Estimates the variance-covariance VaR of a multi-asset portfolio using the Cornish-Fisher adjustment for portfolio-return non-normality, for specified confidence level and holding period.
}
\examples{
# Variance-covariance for randomly generated portfolio
   vc.matrix <- matrix(rnorm(16),4,4)
   mu <- rnorm(4)
   skew <- .5
   kurtosis <- 1.2
   positions <- c(5,2,6,10)
   cl <- .95
   hp <- 280
   AdjustedVarianceCovarianceVaR(vc.matrix, mu, skew, kurtosis, positions, cl, hp)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

