% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/tVaRPlot3D.R
\name{tVaRPlot3D}
\alias{tVaRPlot3D}
\title{Plots t VaR against confidence level and holding period}
\usage{
tVaRPlot3D(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 4
 or 5. In case there 4 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

 returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 df Number of degrees of freedom in the t distribution

 cl VaR confidence level and must be a vector

 hp VaR holding period and must be a vector}
}
\description{
Plots the VaR of a portfolio against confidence level and holding period
assuming that P/L are t distributed, for specified confidence level and
 holding period.
}
\examples{
# Plots VaR against confidene level given geometric return data
   data <- runif(5, min = 0, max = .2)
   tVaRPlot3D(returns = data, df = 6, cl = seq(.85,.99,.01), hp = 60:90)

   # Computes VaR against confidence level given mean and standard deviation of return data
   tVaRPlot3D(mu = .012, sigma = .03, df = 6, cl = seq(.85,.99,.02), hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

