% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ouput.cytoscape.R
\name{make.cytoscape.network}
\alias{make.cytoscape.network}
\title{Drug and Pathway connection output files for Cytoscape visulization}
\usage{
make.cytoscape.network(path.analysis.res = path.analysis.res,
  pathway.FDR.cutoff = 0.1)
}
\arguments{
\item{path.analysis.res}{The pathway analysis results. Output of pathway.analysis().}

\item{pathway.FDR.cutoff}{The FDR threshold to select significant drug specific pathways and the default is 0.1.}
}
\description{
This fucniton allows user to get the two files needed for Cytoscape to visulize the drug-pathway network
}
\examples{

## get the Dr. Insight drug identification results
drug.ident.res = drug.ident(query.data = example.disease, cmap.ref.profiles = example.drug.profiles,
                 repurposing.unit = "treatment", connectivity = "negative")

## load in example pathway data
data("example.pathway")

## Performe pathway analysis (for the drugs that are identified by ident.drug())
path.analysis.res = pathway.analysis(drug.ident.res = drug.ident.res,
                    pathway.list = example.pathway, drug.FDR.cutoff = 0.5)

## get the pathway analysis ouput that can be loaded into Cytoscape for visulization
network.cytoscape = make.cytoscape.network(path.analysis.res = path.analysis.res,
pathway.FDR.cutoff = 0.5)
}
\keyword{analysis}
\keyword{output}
\keyword{pathway}
