% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{characterNames}
\alias{characterNames}
\title{Format Names}
\usage{
characterNames(x, drama, FUN = stringr::str_to_title, sort = 0, ...)
}
\arguments{
\item{x}{The object in which we want to transform names, needs to inherit the type \code{QDHasCharacter}.}

\item{drama}{The QDDrama object with all the information.}

\item{FUN}{A function applied to the strings. 
Defaults to \code{stringr::str_to_title}, which
converts the strings to title case.}

\item{sort}{Numeric. If set to a non-zero value, the resulting data.frame will be sorted 
alphabetically
according to the drama and character name. If the value is above 0, the 
sorting will be ascending, if set to a negative value, the sorting is 
descending. If sort is set to 0 (the default), the order is unchanged. 
The ordering can also be specified explicitly, by passing an integer vector 
with as many elements as \code{x} has rows.}

\item{...}{All other arguments are ignored.}
}
\value{
The function returns \code{x}, but with modified character
names.
}
\description{
The function \code{characterNames()} is applicable on 
all tables with a character table 
(that are of the class \code{QDHasCharacter}). It can be used to reformat the character 
names. The function \code{FUN} is applied to the character \emph{name} entries within 
the \code{QDDrama} object. The factor levels in the character column of \code{x} are replaced by 
the result values of \code{FUN}.
}
\examples{
data(rksp.0)
ustat <- utteranceStatistics(rksp.0)
ustat <- characterNames(ustat, rksp.0)
}
\seealso{
\code{str_to_title}
}
