% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VariousFunctions.R
\name{KSeedsClusters}
\alias{KSeedsClusters}
\title{KSeedsClusters}
\usage{
KSeedsClusters(train, num_clusters, Seed, s)
}
\arguments{
\item{train}{train matrix of features}

\item{num_clusters}{number of clusters desired}

\item{Seed}{subset of drugs features matrix, with just the Seeds as rows}

\item{s}{the seeds of the clusters}
}
\value{
clusters list indicating the cluster to which each drug belongs to
}
\description{
Function Implementing KSeeds. K-Seeds, firstly randomly chooses a number of
drugs (renamed Seeds) equal to the number of clusters desired. Then,
the other drugs are assigned to a cluster with respect to Hamming Distance between the drug and the seed of a certain cluster. Cluster
seeds are not recomputed at each iteration. This allows a speed up in
terms of computational complexity and the algorithm terminates when
all the drugs have been assigned.
}
\examples{
r <- 8
c <- 10
m0 <- matrix(0, r, c)
num_clusters=4
features<-apply(m0, c(1,2), function(x) sample(c(0,1),1))
s<-RandomSeedGenerator(num_clusters,nrow(features))
Seed<-SeedSelection(features,num_clusters,s)
clusters<-KSeedsClusters (features,num_clusters,Seed,s)
}

