% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/VariousFunctions.R
\name{KSeedsScores}
\alias{KSeedsScores}
\title{KSeedsScores}
\usage{
KSeedsScores(train, trainpharmat, num_clusters, Seed, s, clusters)
}
\arguments{
\item{train}{train matrix of features}

\item{trainpharmat}{train matrix of side effects}

\item{num_clusters}{number of clusters desired}

\item{Seed}{subset of the features matrix containing only the Seeds drugs}

\item{s}{the seeds of the clusters}

\item{clusters}{the list of clusters where the various drugs are}
}
\value{
A matrix containing prediction scores for each cluster
}
\description{
Function for obtaining the Bayesian prediction scores using KSeeds clustering
}
\examples{
r <- 8
c <- 10
m0 <- matrix(0, r, c)
num_clusters=4
features<-apply(m0, c(1,2), function(x) sample(c(0,1),1))
#Generate a sample side effects binary matrix
r1 <- 8
c1 <- 10
m1 <- matrix(0, r1, c1)
side_effects<-apply(m1, c(1,2), function(x) sample(c(0,1),1))
s<-RandomSeedGenerator(num_clusters,nrow(features))
Seed<-SeedSelection(features,num_clusters,s)
clusters<-KSeedsClusters (features,num_clusters,Seed,s)
A<-KSeedsScores(features,side_effects,num_clusters,Seed,s,clusters)
}

