% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateIngredientCohortSet.R
\name{generateIngredientCohortSet}
\alias{generateIngredientCohortSet}
\title{Generate a set of drug cohorts based on drug ingredients}
\usage{
generateIngredientCohortSet(
  cdm,
  name,
  ingredient = NULL,
  doseForm = NULL,
  doseUnit = NULL,
  routeCategory = NULL,
  ingredientRange = c(1, Inf),
  gapEra = 1,
  durationRange = lifecycle::deprecated(),
  imputeDuration = lifecycle::deprecated(),
  priorUseWashout = lifecycle::deprecated(),
  priorObservation = lifecycle::deprecated(),
  cohortDateRange = lifecycle::deprecated(),
  limit = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{The name of the new cohort table to add to the cdm reference.}

\item{ingredient}{Accepts both vectors and named lists of ingredient names.
For a vector input, e.g., c("acetaminophen", "codeine"), it generates a
cohort table with descendant concept codes for each ingredient, assigning
unique cohort_definition_id. For a named list input, e.g., list(
"test_1" = c("simvastatin", "acetaminophen"), "test_2" = "metformin"),
it produces a cohort table based on the structure of the input, where
each name leads to a combined set of descendant concept codes for the
specified ingredients, creating distinct cohort_definition_id for each
named group.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{doseUnit}{Only descendants codes with the specified dose unit
will be returned. If NULL, descendant codes will be returned regardless
of dose unit}

\item{routeCategory}{Only descendants codes with the specified route
will be returned. If NULL, descendant codes will be returned regardless
of route category.}

\item{ingredientRange}{Used to restrict descendant codes to those
associated with a specific number of ingredients. Must be a vector of length
two with the first element the minimum number of ingredients allowed and
the second the maximum. A value of c(2, 2) would restrict to only concepts
associated with two ingredients.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era. Records that have fewer days between them than
this gap will be concatenated into the same cohort record.}

\item{durationRange}{Deprecated.}

\item{imputeDuration}{Deprecated.}

\item{priorUseWashout}{Deprecated}

\item{priorObservation}{Deprecated.}

\item{cohortDateRange}{Deprecated.}

\item{limit}{Deprecated.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records with the specified drug ingredient. Cohort start and end
dates will be based on drug record start and end dates, respectively. Records
that overlap or have fewer days between them than the specified gap era will
be concatenated into a single cohort entry.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm <- generateIngredientCohortSet(
  cdm = cdm,
  ingredient = "acetaminophen",
  name = "acetaminophen"
)

cdm$acetaminophen |>
  glimpse()
}

}
