% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateAtcCohortSet.R
\name{generateAtcCohortSet}
\alias{generateAtcCohortSet}
\title{Generate a set of drug cohorts based on ATC classification}
\usage{
generateAtcCohortSet(
  cdm,
  name,
  atcName = NULL,
  level = c("ATC 1st"),
  doseForm = NULL,
  gapEra = 1,
  durationRange = lifecycle::deprecated(),
  imputeDuration = lifecycle::deprecated(),
  priorUseWashout = lifecycle::deprecated(),
  priorObservation = lifecycle::deprecated(),
  cohortDateRange = lifecycle::deprecated(),
  limit = lifecycle::deprecated()
)
}
\arguments{
\item{cdm}{A cdm reference.}

\item{name}{The name of the new cohort table to add to the cdm reference.}

\item{atcName}{Names of ATC classification of interest.}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th"}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{gapEra}{Number of days between two continuous exposures to be
considered in the same era. Records that have fewer days between them than
this gap will be concatenated into the same cohort record.}

\item{durationRange}{Deprecated.}

\item{imputeDuration}{Deprecated.}

\item{priorUseWashout}{Deprecated}

\item{priorObservation}{Deprecated.}

\item{cohortDateRange}{Deprecated.}

\item{limit}{Deprecated.}
}
\value{
The function returns the cdm reference provided with the addition of
the new cohort table.
}
\description{
Adds a new cohort table to the cdm reference with individuals who have drug
exposure records that belong to the specified Anatomical Therapeutic Chemical
(ATC) classification. Cohort start and end dates will be based on drug record
start and end dates, respectively. Records that overlap or have fewer days
between them than the specified gap era will be concatenated into a single
cohort entry.
}
\examples{
\donttest{
library(DrugUtilisation)
library(dplyr)

cdm <- mockDrugUtilisation()

cdm <- generateAtcCohortSet(
  cdm = cdm,
  atcName = "alimentary tract and metabolism",
  name = "drugs"
)

cdm$drugs |>
  glimpse()
}
}
