% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chisqFit.R
\name{chisqFit}
\alias{chisqFit}
\title{Calculate model fit}
\usage{
chisqFit(resObserved, data, DstarM = FALSE, tt = NULL)
}
\arguments{
\item{resObserved}{either output from \code{\link{estObserved}} or a matrix containing custom densities to calculate the fitness for.}

\item{data}{A dataframe containing data.}

\item{DstarM}{Logical. Should the DstarM fit measure be calculated or the traditional fit measure?}

\item{tt}{time grid custom densities where calculated on. Should only be supplied if \code{resOberved} is a matrix containing custom densities}
}
\description{
Calculate model fit
}
\details{
This function allows a user to manually calculate a chi-square goodness of fit measure for model densities.
This is useful for comparing a traditional analysis and a D*M analysis. For completion, this function can also calculate a
D*M fit measure. We do not recommend usage of the D*M measure. While the chi-square fit measure is
identical to the value of the optimizer when fitting, the DstarM fit measure is not equal to that of a DstarM analysis.
This is because this function calculates the DstarM fit measure on the complete distribution, not on the
model distributions, as is done during the optimization.
}
\examples{
tt = seq(0, 5, .1)
pars = c(.8, 2, .5, .5, .5, # condition 1
         .8, 3, .5, .5, .5,  # condition 2
         .8, 4, .5, .5, .5)  # condition 3
pdfND = dbeta(tt, 10, 30)

# simulate data
allDat = simData(n = 3e3, pars = pars, tt = tt, pdfND = pdfND, return.pdf = TRUE)
truePdf = allDat$pdfUnnormalized
dat = allDat$dat
chisqFit(resObserved = truePdf, data = dat, tt = tt)
\dontrun{
# estimate it
define restriction matrix
restr = matrix(1:5, 5, 3)
restr[2, 2:3] = 6:7 # allow drift rates to differ
# fix parameters for speed up
fixed = matrix(c("z1", "a1 / 2", 'sz1', .5, 'sv1', .5), 2, 3)
resD = estDstarM(data = dat, tt = tt, restr = restr, fixed = fixed,
                 Optim = list(parallelType = 1))
resN = estND(resD, Optim = list(parallelType = 1))

resO = estObserved(resD, resN, data = dat)
resO$fit # proper fit
}
}

