% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_construct.R
\name{construct}
\alias{construct}
\title{Construction of a \code{Dyadic} object}
\usage{
construct(height, breadth, type = "vert", distr = "nonrand", param = c(0, 1))
}
\arguments{
\item{height}{positive integer, the number of dyadic levels;}

\item{breadth}{positive integer, the breadth of the dyadic structure;}

\item{type}{string, one of the following character strings:
\code{horiz},\code{vert},\code{symm}, \code{asymm}, which indicates the type of dyadic matrix;}

\item{distr}{string, if it is one the strings 'binom', 'unif', 'norm' it indicate
the type of the distribution used for obtaining the entries, any other string, for example 'nonrand', results in
non-random 1's in all entries.}

\item{param}{vector of two numeric values, these are parameters for the distributions used to generate
the entries.}
}
\value{
A \code{Dyadic}-object.
}
\description{
The function constructs a \code{Dyadic} object either
with random entries (default) or with entries equal to one.
}
\details{
The function constructs a generic \code{Dyadic}-object of any type and
in the case of the \code{symm} type with random entries the object represents a symmetric matrix.
}
\section{References}{

Kos, M., Podgórski, K., & Wu, H. (2025). Dyadic Factorization and Efficient Inversion of Sparse Positive Definite Matrices. arXiv. https://arxiv.org/abs/2505.08144
}

\examples{
#-------------------------------------------------------------#
#---Building 'Dyadic' objects of arbitrary types and sizes ---#
#-------------------------------------------------------------#
N <- 4
k <- 3 # the height and breadth of a dyadic matrix

# Nonrandom vertical dyadic matrix with entries equal to 1
S <- construct(N, k)

S@entries[[N]] # The top level entries
S@entries[[1]] # The bottom level entries

S@type <- "horiz"
# 'S' becomes horizontaly dyadic matrix,
# which is the transpose of the original object

# Symmetric dyadic with entries equal to 1
SS <- construct(N, k, type = "symm")
SS@entries[[2]] # The second bottom level entries

SS@aentries # This list is empty whenever the type is not 'asymm'

# Asymmetric dyadic with entries equal to one
AS <- construct(N, k, type = "asymm")
AS@entries[[2]] # The second bottom level entries
AS@aentries[[2]]
# The asymmetric version
# (which happens to be also symmetric in this case)

# Truly asymmetric
AS <- construct(N, k, type = "asymm", distr = "unif")
AS@entries[[2]] # The second bottom level entries
AS@aentries[[2]] # The second bottom level asymmetric entries
}
\seealso{
\code{\link{Dyadic-class}} for a description of the class.
}
