% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynComm.R
\docType{methods}
\name{community}
\alias{community}
\alias{DynComm.community}
\title{community(vertex)}
\usage{
DynComm.community(dyncomm,vertex)
}
\arguments{
\item{dyncomm}{A DynComm object, if not using the inline version of the 
function call}

\item{vertex}{The name of the intended vertex}
}
\value{
an unsigned integer with the community of the given vertex
}
\description{
Get the community of the given vertex from the selected post processing
algorithm or the main algorithm, after the last iteration.
}
\examples{
library(DynComm)

Parameters<-matrix(c("e","0.1","w", "FALSE"),ncol=2, byrow=TRUE)
dc<-DynComm(ALGORITHM$LOUVAIN,CRITERION$MODULARITY,Parameters)
dc$addRemoveEdges(
 matrix(
   c(0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,1,1,12,13,1,1,1,2,2,2,18,12,19,20,2,3,11,12,4,9,5,9,22)
      ,ncol=2)
)

dc$communities()
dc$community(1)

}
\seealso{
\code{\link{DynComm}} , \code{\link{postProcess}}
}
\author{
poltergeist0
}
