% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynTree_surv.R
\name{DynTree_surv}
\alias{DynTree_surv}
\title{Grow random survival tree using multivariate longitudinal endogenous covariates}
\usage{
DynTree_surv(
  Y,
  Longitudinal = NULL,
  Numeric = NULL,
  Factor = NULL,
  timeVar = NULL,
  mtry = 1,
  nsplit_option = "quantile",
  nodesize = 1,
  minsplit = 2,
  cause = 1,
  seed = 1234
)
}
\arguments{
\item{Y}{A list of output which should contain: \code{type} defines the nature of the outcome, can be "\code{surv}", "\code{numeric}" or "\code{factor}"; \code{Y} is the output variable; \code{id} is the vector of the identifiers for each individuals, they should be the same as the identifiers of the inputs.}

\item{Longitudinal}{A list of longitudinal predictors which should contain: \code{X} a dataframe with one row for repeated measurement and as many columns as markers; \code{id} is the vector of the identifiers for the repeated measurements contained in \code{X}; \code{time} is the vector of the measurement times contained in \code{X}.}

\item{Numeric}{A list of numeric predictors which should contain: \code{X} a dataframe with as many columns as numeric predictors; \code{id} is the vector of the identifiers for each individual.}

\item{Factor}{A list of factor predictors which should contain: \code{X} a dataframe with as many columns as factor predictors; \code{id} is the vector of the identifiers for each individual.}

\item{timeVar}{A character indicating the name of time variable}

\item{mtry}{Number of candidate variables randomly drawn at each node of the trees. This parameter should be tuned by minimizing the OOB error. Default is \code{NULL}.}

\item{nsplit_option}{A character indicates how the values are chosen to build the two groups for the splitting rule (only for continuous predictors). Values are chosen using deciles (\code{nsplit_option}="quantile") or randomly (\code{nsplit_option}="sample"). Default value is "quantile".}

\item{nodesize}{Minimal number of subjects required in both child nodes to split. Cannot be smaller than 1.}

\item{minsplit}{(Only with survival outcome) Minimal number of events required to split the node. Cannot be smaller than 2.}

\item{cause}{(Only with competing events) Number indicates the event of interest.}

\item{seed}{Seed to replicate results}
}
\description{
Grow random survival tree using multivariate longitudinal endogenous covariates
}
\keyword{internal}
