% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/J_class_OptimalClass.R, R/J_optimalClass.R
\name{optimalClass}
\alias{optimalClass}
\alias{.optimalClass}
\title{Perform Classification Step}
\usage{
.optimalClass(moPropen, moMain, moCont, moClass, data, response, txName,
  iter, fSet, suppress, step)

optimalClass(..., moPropen, moMain, moCont, moClass, data, response,
  txName, iter = 0L, fSet = NULL, verbose = TRUE)
}
\arguments{
\item{moPropen}{model object(s) for propensity regression}

\item{moMain}{model object(s) for main effects of outcome regression or NULL}

\item{moCont}{model object(s) for contrasts of outcome regression or NULL}

\item{moClass}{model object(s) for classification procedure}

\item{data}{data.frame of covariates and treatment history}

\item{response}{vector of responses}

\item{txName}{character of column header of data containing tx}

\item{iter}{maximum number of iterations for outcome regression or NULL}

\item{fSet}{function defining subsets or NULL}

\item{suppress}{T/F indicating screen printing preference}

\item{step}{integer indicating step of algorithm}

\item{verbose}{A logical 
If FALSE, screen prints are suppressed.}

\item{moPropen}{An object of class modelObj, which defines the models and R
methods to be used to obtain parameter estimates and
predictions for the propensity for treatment. 
See ?moPropen for details.}

\item{moMain}{An object of class modelObj, which defines the models and R
methods to be used to obtain parameter estimates and
predictions for for the main effects component of the 
outcome regression. 
See ?modelObj for details.
NULL is an appropriate value.}

\item{moCont}{An object of class modelObj, which defines the models and R
methods to be used to obtain parameter estimates and
predictions for for the contrasts component of the
outcome regression. 
See ?modelObj for details.
NULL is an appropriate value.}

\item{moClass}{An object of class modelObj, which defines the
models and R methods to be used to obtain parameter 
estimates and predictions for the classification. 
See ?modelObj for details.}

\item{data}{A data frame of the covariates and tx histories}

\item{response}{The response vector}

\item{txName}{An character giving the column header of the column in data
that contains the tx covariate.}

\item{iter}{An integer
See ?iter for details}

\item{fSet}{A function or NULL. 
This argument allows the user to specify the subset of tx 
options available to a patient. 
See ?fSet for details of allowed structure}
}
\value{
an object of class OptimalClass

an object of class OptimalClass
}
\description{
Perform Classification Step

Classification Perspective
}
\examples{

# Load and process data set
data(bmiData)

# define the negative 12 month change in BMI from baseline
y12 <- -100*(bmiData[,6L] - bmiData[,4L])/bmiData[,4L]

# Define the propensity for treatment model and methods.
moPropen <- buildModelObj(model =  ~ 1, 
                          solver.method = 'glm', 
                          solver.args = list('family'='binomial'),
                          predict.method = 'predict.glm',
                          predict.args = list(type='response'))

# classification model
library(rpart)
moClass <- buildModelObj(model = ~parentBMI+month4BMI+race+gender,
                         solver.method = 'rpart',
                         solver.args = list(method="class"),
                         predict.args = list(type='class'))

#### Second-Stage Analysis using IPW
fitSS_IPW <- optimalClass(moPropen = moPropen, 
                          moClass = moClass,
                          data = bmiData, response = y12,  txName = 'A2')

# outcome model
moMain <- buildModelObj(model = ~parentBMI+month4BMI,
                        solver.method = 'lm')

moCont <- buildModelObj(model = ~race + parentBMI+month4BMI,
                        solver.method = 'lm')

#### Second-Stage Analysis using AIPW
fitSS_AIPW <- optimalClass(moPropen = moPropen, 
                           moMain = moMain, moCont = moCont,
                           moClass = moClass,
                           data = bmiData, response = y12,  txName = 'A2')

##Available methods

  # Retrieve the classification regression object
  classif(object = fitSS_AIPW)

  # Coefficients of the outcome regression objects
  coef(object = fitSS_AIPW)

  # Description of method used to obtain object
  DTRstep(object = fitSS_AIPW)

  # Estimated value of the optimal treatment regime for training set
  estimator(x = fitSS_AIPW)

  # Value object returned by outcome regression method
  fitObject(object = fitSS_AIPW)

  # Estimated optimal treatment and decision functions for training data
  optTx(x = fitSS_AIPW)

  # Estimated optimal treatment and decision functions for new data
  optTx(x = fitSS_AIPW, newdata = bmiData)

  # Value object returned by outcome regression method
  outcome(object = fitSS_AIPW)
  outcome(object = fitSS_IPW)

  # Plots if defined by outcome regression method
  dev.new()
  par(mfrow = c(2,4))

  plot(x = fitSS_AIPW)
  plot(x = fitSS_AIPW, suppress = TRUE)

  # Retrieve the value object returned by propensity regression method
  propen(object = fitSS_AIPW)

  # Show main results of method
  show(object = fitSS_AIPW)

  # Show summary results of method
  summary(object = fitSS_AIPW)
 
#### First-stage Analysis using AIPW

 # Define the propensity for treatment model and methods.
 moPropen <- buildModelObj(model =  ~ 1, 
                           solver.method = 'glm', 
                           solver.args = list('family'='binomial'),
                           predict.method = 'predict.glm',
                           predict.args = list(type='response'))

# classification model
moClass <- buildModelObj(model = ~parentBMI+baselineBMI+race+gender,
                         solver.method = 'rpart',
                         solver.args = list(method="class"),
                         predict.args = list(type='class'))

# outcome model
moMain <- buildModelObj(model = ~parentBMI+baselineBMI,
                        solver.method = 'lm')

moCont <- buildModelObj(model = ~race + parentBMI+baselineBMI,
                        solver.method = 'lm')

fitFS_AIPW <- optimalClass(moPropen = moPropen, 
                           moMain = moMain, moCont = moCont,
                           moClass = moClass,
                           data = bmiData, response = fitSS_AIPW,  
                           txName = 'A1')

##Available methods for fitFS_AIPW are as shown above for fitSS_AIPW

}
\references{
Baqun Zhang, Anastasios A. Tsiatis, Marie Davidian, Min Zhang and
 Eric B. Laber. "Estimating optimal tx regimes from a classification
 perspective." Stat 2012; 1: 103-114. 

Note that this method is a single decision point, binary treatment
method. For multiple decision points, can be called repeatedly.
}
\seealso{
Other statistical methods: \code{\link{bowl}},
  \code{\link{earl}}, \code{\link{iqLearn}},
  \code{\link{optimalSeq}}, \code{\link{owl}},
  \code{\link{qLearn}}, \code{\link{rwl}}

Other single decision point methods: \code{\link{earl}},
  \code{\link{optimalSeq}}, \code{\link{owl}},
  \code{\link{qLearn}}, \code{\link{rwl}}

Other multiple decision point methods: \code{\link{bowl}},
  \code{\link{iqLearn}}, \code{\link{optimalSeq}},
  \code{\link{qLearn}}
}
\concept{multiple decision point methods}
\concept{single decision point methods}
\concept{statistical methods}
\keyword{internal}
