% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DynareR-package.R
\docType{package}
\name{DynareR-package}
\alias{DynareR}
\alias{DynareR-package}
\title{DynareR: Bringing the Power of 'Dynare' to 'R', 'R Markdown', and 'Quarto'}
\description{
It allows running 'Dynare' program from base R, R Markdown and Quarto. 'Dynare' is a software platform for handling a wide class of economic models, in particular dynamic stochastic general equilibrium ('DSGE') and overlapping generations ('OLG') models. This package does not only integrate R and Dynare but also serves as a 'Dynare' Knit-Engine for 'knitr' package. The package requires 'Dynare' (\url{https://www.dynare.org/}) and 'Octave' (\url{https://www.octave.org/download.html}). Write all your 'Dynare' commands in R or R Markdown chunk.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://CRAN.R-project.org/package=DynareR}
  \item Report bugs at \url{https://github.com/sagirumati/DynareR/issues}
}


Other important functions: 
\code{\link{add_matlab_path}()},
\code{\link{add_path}()},
\code{\link{eng_dynare}()},
\code{\link{import_log}()},
\code{\link{include_IRF}()},
\code{\link{input_tex}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\author{
\strong{Maintainer}: Sagiru Mati \email{sagirumati@gmail.com} (\href{https://orcid.org/0000-0003-1413-3974}{ORCID})

}
\concept{important functions}
\keyword{documentation}
