% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/E4.part3.MatchPressesToEDA.R
\name{E4_EDA_Process.part3.MatchPressesToEDA}
\alias{E4_EDA_Process.part3.MatchPressesToEDA}
\title{Match EDA data to button pressess}
\usage{
E4_EDA_Process.part3.MatchPressesToEDA(participant_list,
  rdslocation.MatchedEDA, rdslocation.EDA, rdslocation.buttonpress,
  min.before, min.after, control = TRUE)
}
\arguments{
\item{participant_list}{list of participant numbers NOTE: This should match the names of the folders (e.g., participant 1001's data should be in a folder called "1001")}

\item{rdslocation.MatchedEDA}{folder location where you want the RDS outputs to go (make sure that it ends in /). The combined data file will go into this directory. Individual participants' data will go into a subdirectory in this folder called "individual_participants"}

\item{rdslocation.EDA}{folder where rds files for individual Ps' EDA data are stored (from part 1)}

\item{rdslocation.buttonpress}{location of folder where button press output is stored (from part 2)}

\item{min.before}{how many minutes before a button press do you want EDA data? Enter 0 if you do not want ANY data before (i.e., you're using only data post-press)}

\item{min.after}{how many minutes after a button press do you want EDA data? Enter 0 if you do not want ANY data after (i.e., you're using only data pre-press)}

\item{control}{add in control cases, defaults to T (default is to specify controls from exactly 24 hours prior to the press, provided there was not a press then too)}
}
\description{
This function allows you to extract the data that are within X minutes before and/or after a button press. If there are no button pressess for a participant, it will issue a warning and continue with the next participant.
Inputs: (1) List of participant numbers, (2) location of individual EDA files from step 1, (3) location of button presses from step 2.
Outputs: (1) RDS file with EDA data before and/or after button presses (and control data), for each participant and combined.
}
\examples{
E4_EDA_Process.part3.MatchPressesToEDA(participant_list=c(1001),
                                      rdslocation.buttonpress=paste(system.file(package="E4tools"),
                                      "/extdata/output/presses/",sep=""),
                                      rdslocation.MatchedEDA=paste(tempdir(),
                                      "/extdata/output/matched_EDA/",sep=""),
                                      rdslocation.EDA=paste(system.file(package="E4tools"),
                                      "/extdata/output/raw_EDA/",sep=""),
                                      min.before=20,min.after=20,control=TRUE)
}
\keyword{EDA}
