% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MHInference.R
\name{Postinference.MHLS}
\alias{Postinference.MHLS}
\title{Post-inference for lasso estimator}
\usage{
Postinference.MHLS(X, Y, lbd, weights = rep(1, ncol(X)), tau = rep(1,
  ncol(X)), sig2.hat, alpha = 0.05, nChain = 10, niterPerChain = 500,
  parallel = FALSE, ncores = 2L, returnSamples = FALSE, ...)
}
\arguments{
\item{X}{predictor matrix.}

\item{Y}{response vector.}

\item{lbd}{penalty term of lasso. By letting this argument be \code{"cv.1se"} or
\code{"cv.min"}, users can have the cross-validated lambda that gives either minimum
squared error or that is within 1 std error bound.}

\item{weights}{weight vector with length equal to the number of coefficients.
Default is \code{rep(1, ncol(X))}.}

\item{tau}{numeric vector. Standard deviaion of proposal distribution
for each beta. Adjust the value to get relevant level of acceptance rate.
Default is \code{rep(1, ncol(X))}.}

\item{sig2.hat}{variance of error term.}

\item{alpha}{confidence level for confidence interval.}

\item{nChain}{the number of chains. For each chain, different plug-in beta will be generated
from its confidence region.}

\item{niterPerChain}{the number of iterations per chain.}

\item{parallel}{logical. If \code{parallel = TRUE}, uses parallelization.
Default is \code{parallel = FALSE}.}

\item{ncores}{integer. The number of cores to use for parallelization.}

\item{returnSamples}{logical. If \code{returnSamples = TRUE}, print Metropolis-Hastings samples.}

\item{...}{auxiliary \code{\link{MHLS}} arguments.}
}
\value{
\item{MHsamples}{a list of class MHLS.}

\item{confidenceInterval}{(1-alpha) confidence interval
for each active coefficient.}
}
\description{
Provides confidence intervals for the set of active coefficients
from lasso estimator using Metropolis-Hastings sampler.
}
\details{
This function provides post-selection inference for lasso estimator.
Using Metropolis-Hastings sampler with multiple chains, generates \code{(1-alpha)}
confidence interval for each active coefficients.
Set \code{returnSamples = TRUE} to check the samples.
Check the acceptance rate and adjust \code{tau} accordingly.
We recommend to set \code{nChain >= 10} and \code{niterPerChain >= 500}.
}
\examples{
set.seed(123)
n <- 5
p <- 10
X <- matrix(rnorm(n*p),n)
Y <- X \%*\% rep(1,p) + rnorm(n)
sig2 <- 1
lbd <- .37
weights <- rep(1,p)
Postinference.MHLS(X = X, Y = Y, lbd = lbd, sig2.hat = 1, alpha = .05,
nChain = 3, niterPerChain = 20, parallel = TRUE)
Postinference.MHLS(X = X, Y = Y, lbd = lbd, sig2.hat = 1, alpha = .05,
nChain = 3, niterPerChain = 20, parallel = TRUE, returnSamples = TRUE)
}
