#' Validate the performance of EBPRS
#' @param score polygenic score generated by 'EBPRS'
#' @param truey the true phenotype (the 6th column in the fam file)
#' @export
#' @import stats ROCR
#' @description
#' Provide the performance evaluated by predictive r2 and AUC.
#' @references
#' Song, S., Jiang, W., Hou, L. and Zhao, H. (2019). Leveraging effect size distributions to improve polygenic risk scores derived from genome-wide association studies. \emph{PLoS Compuational Biology}.
#' @examples
#' validate(score=rnorm(20,0,1), truey=sample(0:1,20,replace=TRUE))
#' @seealso
#' \code{\link{EBPRS}}
#'
#' @author
#' Shuang Song, Wei Jiang, Lin Hou and Hongyu Zhao




validate <- function(score,truey){
  if(length(table(truey))==2){
    auc <- printAUC(score,truey)
    r2 <- cor(score,truey)^2
    cat("The R2 equals to ",r2,"\n")
    cat("The AUC equals to",auc,"\n")
    return(list(r2=r2,AUC=auc))
  }else if(length(table(score))==2){
    auc <- printAUC(truey,score)
    r2 <- cor(score,truey)^2
    cat("Please check the order of truey and score.")
    cat("The R2 equals to ",r2,"\n")
    cat("The AUC equals to",auc,"\n")
    return(list(r2=r2,AUC=auc))
  }else if(length(table(truey))==3){
    loss <- which(truey==-9)
    score <- score[-loss]
    truey <- truey[-loss]
  }
  else{
    r2 <- cor(score,truey)^2
    cat("The R2 equals to ",r2,"\n")
    #cat("The AUC equals to",auc,"\n")
    return(list(r2=r2))
  }


}
