% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KSCovL2sup.R
\name{oneSPL}
\alias{oneSPL}
\title{oneSPL of L2-norm test}
\usage{
oneSPL(odata, sample_num, k, p, n)
}
\arguments{
\item{odata}{The list variable containing k groups of presmoothed functional observations. 
Each element of the list is a p (number sampling points) by n (sample size) matrix.}

\item{sample_num}{vector of group sizes.}

\item{k}{number of groups.}

\item{p}{number of time points.}

\item{n}{total number of samples.}
}
\value{
The value of test statistic.
}
\description{
Generate one pseudo sample by resampling and compute the value of the L2-norm test statistic.
}
\details{
The input data should have been centered. This function is obsolete and implemented in R, 
for testing purpose only. Should use \code{\link{oneSPLL2}} instead.
}
\examples{
p <- 100; sample_num <- c(40,60); k <- length(sample_num); n <- sum(sample_num);
odata <- matrix(rnorm(p*n),p,n);
oneSPL(odata, sample_num, k, p, n);
}
\references{
ZHANG (2013), GUO et al. (2016).
}
\seealso{
\code{\link{oneSPLL2}}, \code{\link{oneSPLmax}}.
}
