% Generated by roxygen2 (4.0.2): do not edit by hand
\name{psrf}
\alias{psrf}
\title{Calculates the potential scale reduction factor.}
\usage{
psrf(parameters)
}
\arguments{
\item{parameters}{A list of MCMC trajectories, where each trajectory is a
matrix with NumParams rows and NumIterations columns, where NumParams is the
number of parameters and NumIterations is the number of samples.}
}
\value{
A vectors of length NumParams, containing the PSRF values for each
parameter.
}
\description{
This function calculates the potential scale reduction factor of parameters
or hyperparameters over several MCMC simulations (or one simulation split
up). This can serve as a convergence diagnostic.
}
\examples{
# Generate 5 'runs' of random samples from Gaussian N(0,1)
samples = list()

for(run in 1:5) {
  samples[[run]] = matrix(rnorm(1000), 1, 1000)
}

# Check potential scale reduction factor
# (Will be very close to 1 due to the samples being from
# the same distribution)
psrf.val = psrf(samples)


# Now use slightly different Gaussian distributions for each 'run'.
for(run in 1:5) {
  mean = runif(1, 0, 2)
  samples[[run]] = matrix(rnorm(1000, mean, 1), 1, 1000)
}

# Check potential scale reduction factor
# (Should be > 1.1)
psrf.val = psrf(samples)
}
\author{
Sophie Lebre

Frank Dondelinger
}
\references{
Gelman and Rubin (1992) Inference from iterative simulation
using multiple sequences, Statistical Science.
}
\seealso{
\code{\link{psrf_check}}, \code{\link{psrf_check_hyper}}
}

