% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_status_create.R
\name{check_status_create}
\alias{check_status_create}
\title{Check data package creation status}
\usage{
check_status_create(transaction, wait = TRUE, env = "production")
}
\arguments{
\item{transaction}{(character) Transaction identifier}

\item{wait}{(logical) Wait for evaluation to complete? See details below.}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(logical) TRUE if creation has completed, FALSE if in progress, and
error if an error was encountered while processing the request
}
\description{
Check data package creation status
}
\details{
If \code{wait = TRUE}, then the function will enter a "while" loop
checking every 2 seconds for the completed evaluation report. If
\code{wait = FALSE}, then the function will only check once and return the
result.
}
\note{
User authentication is required (see \code{login()})
}
\examples{
\dontrun{

login()

# Create data package
transaction <- create_data_package(
  eml = paste0(tempdir(), "/edi.595.1.xml"),
  env = "staging"
)
transaction
#> [1] "create_163966765080210573__edi.595.1"

# Check creation status
status <- check_status_create(
  transaction = transaction,
  env = "staging"
)
status
#> [1] TRUE

logout()
}

}
\seealso{
Other Evaluation and Upload: 
\code{\link{check_status_evaluate}()},
\code{\link{check_status_update}()},
\code{\link{create_data_package}()},
\code{\link{evaluate_data_package}()},
\code{\link{update_data_package}()}
}
\concept{Evaluation and Upload}
