% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_data_entities.R
\name{list_data_entities}
\alias{list_data_entities}
\title{List data entities}
\usage{
list_data_entities(packageId, env = "production")
}
\arguments{
\item{packageId}{(character) Data package identifier}

\item{env}{(character) Repository environment. Can be: "production",
"staging", or "development".}
}
\value{
(character) Identifiers for all data entities in \code{packageId}
}
\description{
List data entities
}
\examples{
\dontrun{

entityIds <- list_data_entities("knb-lter-and.2732.7")
entityIds
#> [1] "0464a1d9262fc6e609cb0b24adb7e5ba"
#> [2] "cc3ade83d3655edd2ca674721a52ef46"
}
}
\seealso{
Other Listing: 
\code{\link{list_data_descendants}()},
\code{\link{list_data_package_identifiers}()},
\code{\link{list_data_package_revisions}()},
\code{\link{list_data_package_scopes}()},
\code{\link{list_data_sources}()},
\code{\link{list_deleted_data_packages}()},
\code{\link{list_recent_changes}()},
\code{\link{list_recent_uploads}()},
\code{\link{list_service_methods}()},
\code{\link{list_user_data_packages}()}
}
\concept{Listing}
