% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphOperation.R
\name{getiGraphOBJ}
\alias{getiGraphOBJ}
\title{getiGraphOBJ function}
\usage{
getiGraphOBJ(adjMat, sortedGroupList)
}
\arguments{
\item{adjMat}{is an adjacency matrix of a dominant-distribution network.}

\item{sortedGroupList}{is a list of names of categories ascendingly ordered by their means.}
}
\value{
This function returns an iGraph object of a dominant-distribution network for a given adjMat.
}
\description{
getiGraphOBJ is a support function for converting a dominant-distribution network adjacency matrix to an iGraph object.
}
\examples{
# Generate simulation data with 100 samples per categories

simData<-SimNonNormalDist(nInv=100)

# Performing ordering infernce from simData

resultObj<-EDOIF(simData$Values,simData$Group)

# Get an iGraph object from an adjacency matrix

igraphObj<-getiGraphOBJ(adjMat=resultObj$adjMat,sortedGroupList=resultObj$sortedGroupList)

}
