% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EFAvote.R
\name{EFAvote}
\alias{EFAvote}
\title{Voting Method for Number of Factors in EFA}
\usage{
EFAvote(votes, vis = TRUE, plot = TRUE)
}
\arguments{
\item{votes}{A vector of integers, where each element corresponds to the number of factors suggested
by an EFA method.}

\item{vis}{Logical, whether to print the results of the voting. Defaults to \code{TRUE}.}

\item{plot}{Logical, whether to display a pie chart of the voting results. Defaults to \code{TRUE}.}
}
\value{
An object of class \code{EFAvote}, which is a list containing:
\item{nfact}{The number of factors with the most votes. If there is a tie, the first one in the order is returned.}
\item{votes}{The original vector of votes.}
}
\description{
This function implements a voting method to determine the most appropriate number of factors
in exploratory factor analysis (EFA). The function accepts a vector of votes, where each value
represents the number of factors suggested by different EFA approaches. If there is a clear
winner (a single number of factors with the most votes), that number is returned. In case of
a tie, the function returns the first value among the tied results and outputs a message. The
result is returned as an object of class \code{vote}, which can be printed and plotted.
}
\examples{
library(EFAfactors)

nfacts <- c(5, 5, 5, 6, 6, 4)
names(nfacts) <- c("Hull", "CD", "PA", "EKC", "XGB", "DNN")

EFAvote.obj <- EFAvote(votes = nfacts)

# Visualize the voting results
plot(EFAvote.obj)

}
\seealso{
\link[EFAfactors]{plot.EFAvote}
}
