% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FACTOR_SCORES.R
\name{FACTOR_SCORES}
\alias{FACTOR_SCORES}
\title{Estimate factor scores for an EFA model}
\usage{
FACTOR_SCORES(
  x,
  f,
  Phi = NULL,
  method = c("Thurstone", "tenBerge", "Anderson", "Bartlett", "Harman", "components"),
  impute = c("none", "means", "median")
)
}
\arguments{
\item{x}{data.frame or matrix. Dataframe or matrix of raw data (needed to get
factor scores) or matrix with correlations.}

\item{f}{object of class \code{\link{EFA}} or matrix.}

\item{Phi}{matrix. A matrix of factor intercorrelations. Only needs to be
specified if a factor loadings matrix is entered directly into \code{f}.
Default is \code{NULL}, in which case all intercorrelations are assumed to be zero.}

\item{method}{character. The method used to calculate factor scores. One of
"Thurstone" (regression-based; default), "tenBerge", "Anderson", "Bartlett",
"Harman", or "components".
See \code{\link[psych:factor.scores]{psych::factor.scores}} for details.}

\item{impute}{character. Whether and how missing values in \code{x} should
be imputed. One of "none" (default, only complete cases are scored), "median",
or "mean".}
}
\value{
A list of class FACTOR_SCORES containing the following:

\item{scores}{The factor scores (only if raw data are provided.)}
\item{weights}{The factor weights.}
\item{r.scores}{The correlations of the factor score estimates.}
\item{missing}{A vector of the number of missing observations per subject
(only if raw data are provided.}
\item{R2}{Multiple R2 of the scores with the factors.}
\item{settings}{A list of the settings used.}
}
\description{
This is a wrapper function for
\code{\link[psych:factor.scores]{psych::factor.scores}} to be used directly
with an output from \code{\link{EFA}} or by manually specifying the factor
loadings and intercorrelations. Calculates factor scores according to the
specified methods if raw data are provided, and only factor weights if a
correlation matrix is provided.
}
\examples{
# Example with raw data with method "Bartlett" and no imputation
EFA_raw <- EFA(DOSPERT_raw, n_factors = 10, type = "EFAtools", method = "PAF",
               rotation = "oblimin")
fac_scores_raw <- FACTOR_SCORES(DOSPERT_raw, f = EFA_raw, method = "Bartlett",
                                impute = "none")

# Example with a correlation matrix (does not return factor scores)
EFA_cor <- EFA(test_models$baseline$cormat, n_factors = 3, N = 500,
               type = "EFAtools", method = "PAF", rotation = "oblimin")
fac_scores_cor <- FACTOR_SCORES(test_models$baseline$cormat, f = EFA_cor)

}
