% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entropyFit.R
\name{entropyFit}
\alias{entropyFit}
\title{Entropy Fit Indices}
\usage{
entropyFit(data, structure)
}
\arguments{
\item{data}{A dataset}

\item{structure}{A vector representing the structure (numbers or labels for each item).
Can be theoretical factors or the structure detected by \code{\link{EGA}}}
}
\value{
Returns a list containing:

\item{Ind.Entropy}{The entropy of the dataset}

\item{Mean.Entropy}{The average entropy across the factors}

\item{Joint.Entropy}{The joint entropy across the factors}

\item{H.Miller.Madow}{Miller-Madow correction for the entropy of the dataset}

\item{Mean.Entropy.MM}{Miller-Madow correction for the average entropy across the factors}

\item{Joint.Miller.Madow}{Miller-Madow correction for the joint entropy across the factors}

\item{Total.Correlation}{The total correlation of the dataset}

\item{Total.Correlation.MM}{Miller-Madow correction for the total correlation of the dataset}

\item{Entropy.Fit}{The Entropy Fit Index}

\item{Entropy.Fit.MM}{Miller-Madow correction for the Entropy Fit Index}

\item{Average.Entropy}{The average entropy of the dataset}
}
\description{
Computes the fit of a factor model using empirical entropy
Lower values of the entropy fit indices suggest better factor fit
}
\examples{
\donttest{
#estimate EGA model
ega.wmt <- EGA(data = wmt2[,7:24], model = "glasso")

#compute entropy indices
entropyFit(data = wmt2[,7:24], structure = ega.wmt$wc)
}
}
\seealso{
\code{\link{EGA}} to estimate the number of dimensions of an instrument using EGA and \code{\link{CFA}} to
verify the fit of the structure suggested by EGA using confirmatory factor analysis.
}
\author{
Hudson F. Golino <hfg9s at virginia.edu> and Alexander P. Christensen <alexpaulchristensen@gmail.com>
}
