% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynEGA.R
\name{dynEGA}
\alias{dynEGA}
\title{Dynamic Exploratory Graph Analysis}
\usage{
dynEGA(
  data,
  n.embed,
  tau = 1,
  delta = 1,
  level = c("individual", "group", "population"),
  id = NULL,
  group = NULL,
  use.derivatives = 1,
  model = c("glasso", "TMFG"),
  algorithm = c("walktrap", "louvain"),
  plot.EGA = TRUE,
  cor = c("cor_auto", "pearson", "spearman"),
  steps = 4,
  ncores
)
}
\arguments{
\item{data}{A dataframe with the variables to be used in the analysis. The dataframe should be in a long format (i.e. observations for the same individual (for example, individual 1) are placed in order, from time 1 to time t, followed by the observations from individual 2, also ordered from time 1 to time t.)}

\item{n.embed}{Integer.
Number of embedded dimensions (the number of observations to be used in the \code{\link[EGAnet]{Embed}} function). For example,
an \code{"n.embed = 5"} will use five consecutive observations to estimate a single derivative.}

\item{tau}{Integer.
Number of observations to offset successive embeddings in the \code{\link[EGAnet]{Embed}} function. A tau of one uses adjacent observations.
Default is \code{"tau = 1"}.}

\item{delta}{Integer.
The time between successive observations in the time series.
Default is \code{"delta = 1"}.}

\item{level}{Character.
A string indicating the level of analysis. If the interest is
in modeling the intraindividual structure only (one dimensionality structure per individual), then \code{level} should be set to \code{"individual"}.
If the interest is in the structure of a group of individuals, then \code{level} should be set to \code{"group"}.
Finally, if the interest is in the population structure, then \code{level} should be set to \code{"population"}.

Current options are:

\itemize{

\item{\strong{\code{individual}}}
{Estimates the dynamic factors per individual. This should be the prefered method is one is interested in
in the factor structure of individuals. An additional parameter (\code{"id"}) needs to be provided identifying each individual.}

\item{\strong{\code{group}}}
{Estimates the dynamic factors for each group.
An additional parameter (\code{"group"}) needs to be provided identifying the group membership.}

\item{\strong{\code{population}}}
{Estimates the dynamic factors of the population}

}}

\item{id}{Numeric.
Number of the column identifying each individual.}

\item{group}{Numeric or character.
Number of the column identifying group membership. Must be specified only if \code{level = "group"}.}

\item{use.derivatives}{Integer.
The order of the derivative to be used in the EGA procedure. Default to 1.}

\item{model}{A string indicating the network method to use (\code{\link{EGA.estimate}}).
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter.
This is the default method}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{algorithm}{A string indicating the community detection algorithm to use.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{plot.EGA}{Logical.
If TRUE, returns a plot of the network and its estimated dimensions.
Defaults to TRUE}

\item{cor}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{steps}{Number of steps to be used in \code{\link[igraph]{cluster_walktrap}} algorithm.
Defaults to 4.}

\item{ncores}{Numeric.
Number of cores to use in computing results.
Defaults to \code{parallel::detectCores() / 2} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing.
Recommended to use maximum number of cores minus one

If you're unsure how many cores your computer has,
then use the following code: \code{parallel::detectCores()}}
}
\description{
Estimates dynamic factors in multivariate time series (i.e. longitudinal data, panel data, intensive longitudinal data) at multiple
time scales, in different levels of analysis: individuals (intraindividual structure), groups or population (structure of the population).
Exploratory graph analysis is applied in the derivatives estimated using generalized local linear approximation (\code{\link[EGAnet]{glla}}). Instead of estimating factors by modeling how variables are covarying, as in traditional
EGA, dynEGA is a dynamic model that estimates the factor structure by modeling how variables are changing together.
GLLA is a filtering method for estimating derivatives from data that uses time delay embedding and a variant of Savitzky-Golay filtering to accomplish the task.
}
\examples{

\donttest{
# Population structure:
dyn.random <- dynEGA(data = sim.dynEGA, n.embed = 5, tau = 1,
delta = 1, id = 21, group = 22, use.derivatives = 1,
level = "population", model = "glasso")


# Group structure:
dyn.group <- dynEGA(data = sim.dynEGA, n.embed = 5, tau = 1,
delta = 1, id = 21, group = 22, use.derivatives = 1,
level = "group", model = "glasso")

# Intraindividual structure:

dyn.individual <- dynEGA(data = sim.dynEGA, n.embed = 5, tau = 1,
delta = 1, id = 21, group = 22, use.derivatives = 1,
level = "individual", model = "glasso")
}
}
\references{
Boker, S. M., Deboeck, P. R., Edler, C., & Keel, P. K. (2010)
Generalized local linear approximation of derivatives from time series. In S.-M. Chow, E. Ferrer, & F. Hsieh (Eds.),
\emph{The Notre Dame series on quantitative methodology. Statistical methods for modeling human dynamics: An interdisciplinary dialogue},
(p. 161–178). \emph{Routledge/Taylor & Francis Group}.
doi:\href{https://doi.org/10.1037/a0016622}{10.1037/a0016622}

Deboeck, P. R., Montpetit, M. A., Bergeman, C. S., & Boker, S. M. (2009)
Using derivative estimates to describe intraindividual variability at multiple time scales.
\emph{Psychological Methods}, \emph{14(4)}, 367-386.
doi:\href{https://doi.org/10.1037/a0016622}{10.1037/a0016622}

Golino, H. F., & Epskamp, S. (2017).
Exploratory graph analysis: A new approach for estimating the number of dimensions in psychological research.
\emph{PloS one}, \emph{12(6)}, e0174035..
doi: \href{https://doi.org/10.1371/journal.pone.0174035}{journal.pone.0174035}
Savitzky, A., & Golay, M. J. (1964).
Smoothing and differentiation of data by simplified least squares procedures.
\emph{Analytical Chemistry}, \emph{36(8)}, 1627-1639.
doi:\href{https://doi.org/10.1021/ac60214a047}{10.1021/ac60214a047}
}
\author{
Hudson Golino <hfg9s at virginia.edu>
}
