% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hierEGA.R
\name{hierEGA}
\alias{hierEGA}
\title{Hierarchical \code{\link[EGAnet]{EGA}}}
\usage{
hierEGA(
  data,
  scores = c("factor", "network"),
  consensus.iter = 1000,
  consensus.method = c("highest_modularity", "most_common", "iterative", "lowest_tefi"),
  uni.method = c("expand", "LE"),
  corr = c("cor_auto", "pearson", "spearman"),
  model = c("glasso", "TMFG"),
  model.args = list(),
  algorithm = c("walktrap", "louvain"),
  algorithm.args = list(),
  plot.EGA = TRUE,
  plot.type = c("GGally", "qgraph"),
  plot.args = list(),
  verbose = TRUE
)
}
\arguments{
\item{data}{Matrix or data frame.
Variables (down columns) only.
Does not accept correlation matrices}

\item{scores}{Character.
How should scores for the higher-order structure be estimated?
Defaults to \code{"network"} for network scores computed using
the \code{\link[EGAnet]{net.scores}} function.
Set to \code{"factor"} for factor scores computed using
\code{\link[psych]{fa}}. Factors are assumed to be correlated
using the \code{"oblimin"} rotation. \emph{NOTE}: Factor scores
use the number of communities from \code{\link[EGAnet]{EGA}}.
Estimated factor may not align with these communities. The plots
using factor scores with have higher order factors that may not
completely map onto the lower order communities. Look at the
\code{$hierarchical$higher_order$lower_loadings} to determine
the composition of the lower order factors.

By default, both factor and network scores are computed and stored
in the output. The selected option only appears in the main output (\code{$hierarchical})}

\item{consensus.iter}{Numeric.
Number of iterations to perform in consensus clustering
(see Lancichinetti & Fortunato, 2012).
Defaults to \code{1000}}

\item{consensus.method}{Character.
What consensus clustering method should be used? 
Defaults to \code{"highest_modularity"}.
Current options are:

\itemize{

\item{\strong{\code{highest_modularity}}}
{Uses the community solution that achieves the highest modularity
across iterations}

\item{\strong{\code{most_common}}}
{Uses the community solution that is found the most
across iterations}

\item{\strong{\code{iterative}}}
{Identifies the most common community solutions across iterations
and determines how often nodes appear in the same community together.
A threshold of 0.30 is used to set low proportions to zero.
This process repeats iteratively until all nodes have a proportion of
1 in the community solution.
}

\item{\code{lowest_tefi}}
{Uses the community solution that achieves the lowest \code{\link[EGAnet]{tefi}}
across iterations}

}

By default, all \code{consensus.method} options are computed and
stored in the output. The selected method will be used to
plot and appear in the main output (\code{$hierarchical})}

\item{uni.method}{Character.
What unidimensionality method should be used? 
Defaults to \code{"LE"}.
Current options are:

\itemize{

\item{\strong{\code{expand}}}
{Expands the correlation matrix with four variables correlated .50.
If number of dimension returns 2 or less in check, then the data 
are unidimensional; otherwise, regular EGA with no matrix
expansion is used. This is the method used in the Golino et al. (2020)
\emph{Psychological Methods} simulation.}

\item{\strong{\code{LE}}}
{Applies the leading eigenvalue algorithm (\code{\link[igraph]{cluster_leading_eigen}})
on the empirical correlation matrix. If the number of dimensions is 1,
then the leading eigenvalue solution is used; otherwise, regular EGA
is used. This is the final method used in the Christensen, Garrido,
and Golino (2021) simulation.}

}}

\item{corr}{Type of correlation matrix to compute. The default uses \code{\link[qgraph]{cor_auto}}.
Current options are:

\itemize{

\item{\strong{\code{cor_auto}}}
{Computes the correlation matrix using the \code{\link[qgraph]{cor_auto}} function from
\code{\link[qgraph]{qgraph}}}.

\item{\strong{\code{pearson}}}
{Computes Pearson's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.

\item{\strong{\code{spearman}}}
{Computes Spearman's correlation coefficient using the pairwise complete observations via
the \code{\link[stats]{cor}}} function.
}}

\item{model}{Character.
A string indicating the method to use.
Defaults to \code{"glasso"}.
Current options are:

\itemize{

\item{\strong{\code{glasso}}}
{Estimates the Gaussian graphical model using graphical LASSO with
extended Bayesian information criterion to select optimal regularization parameter}

\item{\strong{\code{TMFG}}}
{Estimates a Triangulated Maximally Filtered Graph}

}}

\item{model.args}{List.
A list of additional arguments for \code{\link[EGAnet]{EBICglasso.qgraph}}
or \code{\link[NetworkToolbox]{TMFG}}}

\item{algorithm}{A string indicating the algorithm to use or a function from \code{\link{igraph}}
Defaults to \code{"louvain"}.
Current options are:

\itemize{

\item{\strong{\code{walktrap}}}
{Computes the Walktrap algorithm using \code{\link[igraph]{cluster_walktrap}}}

\item{\strong{\code{louvain}}}
{Computes the Louvain algorithm using \code{\link[igraph]{cluster_louvain}}}

}}

\item{algorithm.args}{List.
A list of additional arguments for \code{\link[igraph]{cluster_walktrap}}, \code{\link[igraph]{cluster_louvain}},
or some other community detection algorithm function (see examples)}

\item{plot.EGA}{Boolean.
If \code{TRUE}, returns a plot of the network and its estimated dimensions.
Defaults to \code{TRUE}}

\item{plot.type}{Character.
Plot system to use.
Current options are \code{\link[qgraph]{qgraph}} and \code{\link{GGally}}.
Defaults to \code{"GGally"}}

\item{plot.args}{List.
A list of additional arguments for the network plot.
For \code{plot.type = "qgraph"}:

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

}
For \code{plot.type = "GGally"} (see \code{\link[GGally]{ggnet2}} for
full list of arguments):

\itemize{

\item{\strong{\code{vsize}}}
{Size of the nodes. Defaults to 6.}

\item{\strong{\code{label.size}}}
{Size of the labels. Defaults to 5.}

\item{\strong{\code{alpha}}}
{The level of transparency of the nodes, which might be a single value or a vector of values. Defaults to 0.7.}

\item{\strong{\code{edge.alpha}}}
{The level of transparency of the edges, which might be a single value or a vector of values. Defaults to 0.4.}

 \item{\strong{\code{legend.names}}}
{A vector with names for each dimension}

\item{\strong{\code{color.palette}}}
{The color palette for the nodes. For custom colors,
enter HEX codes for each dimension in a vector.
See \code{\link[EGAnet]{color_palette_EGA}} for
more details and examples}

}}

\item{verbose}{Boolean.
Should network estimation parameters be printed?
Defaults to \code{TRUE}.
Set to \code{FALSE} for no print out}
}
\value{
Returns a list of lists containing: \cr
\cr
\strong{Main Results} \cr

\item{hierarhical}{The main results list containing:

\itemize{

\item{\code{lower_order}}
{Lower order \code{\link[EGAnet]{EGA}} results for the selected methods}

\item{\code{higher_order}}
{Higher order \code{\link[EGAnet]{EGA} results for the selected methods}}

If \code{plot.EGA = TRUE}, then:

\item{\code{lower_plot}}
{Plot of the lower order results}

\item{\code{higher_plot}}
{Plot of the higher order results}

\item{\code{hier_plot}}
{Plot of the lower and higher order results together, side-by-side}

}

}

\strong{Secondary Results} \cr

\item{lower_ega}{A list containing the lower order \code{\link[EGAnet]{EGA}}
results. The \code{$wc} does not contain valid results. Do not use its output.
}

\item{lower_wc}{A list containing consensus clustering results:

\itemize{

\item{\code{highest_modularity}}
{Community memberships based on the highest modularity across the
\code{\link[igraph]{cluster_louvain}} applications}

\item{\code{most_common}}
{Community memberships based on the most commonly found memberships across the
\code{\link[igraph]{cluster_louvain}} applications}

\item{\code{iterative}}
{Community memberships based on consensus clustering described by
Lancichinetti & Fortunato (2012)}

\item{\code{lowest_tefi}}
{Community memberships based on the lowest \code{\link[EGAnet]{tefi}}
across the \code{\link[igraph]{cluster_louvain}} applications}

\item{\code{summary_table}}
{A data frame summarizing the unique community solutions across the iterations. Down the
columns indicate: number of dimensions (\code{N_Dimensions}),
proportion of times each community solution was identified (\code{Proportion}),
modularity of each community solution (\code{Modularity}),
total entropy fit index of each community solution (\code{\link[EGAnet]{tefi}}), 
and the memberships for each item. Across the rows indicate each
unique community solution
}

}

}

\item{factor_results}{A list containing higher order results based on factor scores.
A list for each \code{consensus.method} is provided with their \code{\link[EGAnet]{EGA}} results}

\item{network_results}{A list containing higher order results based on network scores.
A list for each \code{consensus.method} is provided with their \code{\link[EGAnet]{EGA}} results}
}
\description{
Estimates EGA using the lower-order solution of \code{\link[igraph]{cluster_louvain}}
to identify the lower-order dimensions and then uses factor or network loadings to
estimate factor or network scores, which are used to estimate the higher-order dimensions
}
\examples{
# Obtain example data
data <- optimism

# hierEGA example (no plots)
opt.hier<- hierEGA(
  data = optimism,
  algorithm = "louvain",
  plot.EGA = FALSE # no plots for CRAN check
)

\dontrun{

# hierEGA example (plots)
opt.hier <- hierEGA(
  data = optimism,
  algorithm = "louvain"
)

# Save plots
ggplot2::ggsave(
  filename = "hierEGA_plot.png", # name of plot
  plot = opt.res$hierarchical$hier_plot, # plot to save
  height = 8, # figure height
  width = 10, # figure width
  dpi = 600 # dots per inch
)

}


}
\references{
Lancichinetti, A., & Fortunato, S. (2012).
Consensus clustering in complex networks.
\emph{Scientific Reports}, \emph{2}(1), 1-7.
}
\author{
Marcos Jimenez <marcosjnezhquez@gmailcom>,
Francisco J. Abad <fjose.abad@uam.es>,
Eduardo Garcia-Garzon <egarcia@ucjc.edu>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu.do>,
Alexander P. Christensen <alexpaulchristensen@gmail.com>, and
Hudson Golino <hfg9s at virginia.edu>
}
