% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot.ergoInfo.R
\name{boot.ergoInfo}
\alias{boot.ergoInfo}
\title{Bootstrap Test for the Ergodicity Information Index}
\usage{
boot.ergoInfo(dynEGA.object, EII, iter = 100, ncores, progress = TRUE)
}
\arguments{
\item{dynEGA.object}{A \code{\link[EGAnet]{dynEGA}} or a
\code{\link[EGAnet]{dynEGA.ind.pop}} object that is used to match the arguments of the EII object.}

\item{EII}{A \code{\link[EGAnet]{ergoInfo}} object, used to estimate the Empirical Ergodicity Information Index, or the estimated value of EII estimated
using the \code{\link[EGAnet]{ergoInfo}} function. Inherits \code{use} from \code{\link[EGAnet]{ergoInfo}}}

\item{iter}{Numeric integer.
Number of replica samples to generate from the bootstrap analysis.
At least \code{100} is recommended}

\item{ncores}{Numeric.
Number of cores to use in computing results.
Defaults to \code{parallel::detectCores() / 2} or half of your
computer's processing power.
Set to \code{1} to not use parallel computing.
Recommended to use maximum number of cores minus one

If you're unsure how many cores your computer has,
then use the following code: \code{parallel::detectCores()}}

\item{progress}{Boolean.
Should progress be displayed?
Defaults to \code{TRUE}.
For Windows, \code{FALSE} is about 2x faster}
}
\value{
Returns a list containing:

\item{boot.ergoInfo}{The values of the Ergodicity Information Index obtained in the bootstrap}

\item{p.value}{The two-sided *p*-value of the bootstrap test for the Ergodicity Information Index.
The null hypothesis is that the empirical Ergodicity Information index is equal to the expected value of the EII
with small variation in the population structure}

\item{effect}{Indicates wheter the empirical EII is greater or less then the bootstrap distribution of EII.}

\item{interpretation}{How you can interpret the result of the test in plain English}

\item{plot.dist}{Histogram of the bootstrapped ergodicity information index}

\item{methods}{Methods to report for print/summary S3methods and automated Methods section}
}
\description{
Tests the Ergodicity Information Index obtained in the empirical sample with a distribution of EII 
obtained by bootstrap sampling. In traditional bootstrap sampling, individual participants are resampled with
replacement from the empirical sample. This process is time consuming when carried out across \emph{v} number
of variables, \emph{n} number of participants, \emph{t} number of time points, and \emph{i} number of iterations.

A more efficient process, the approach applied here, is to obtain a sampling distribution of EII values as if
all participants in the data have the population network structure. Sampling is not perfect and therefore
random noise is added to the edges of the population structure to simulate sampling variability. This noise
follows a random uniform distribution ranging from -0.10 to 0.10. In addition, a proportion of edges are
rewired to allow for slight variations on the population structure. The proportion of nodes that are rewired
is sampled from a random uniform distribution between 0.20 to 0.40. This process is carried out for each
participant resulting in \emph{n} variations of the population structure. Afterward, EII is computed. This
process is carried out for \emph{i} iterations (e.g., 100).

The result is a sampling distribution of EII values that would be expected if the process was ergodic. If
the empirical EII value is significantly less than the distribution or not significantly different, then 
the empirical data can be expected to be generated from an ergodic process and the population structure is 
sufficient to describe all individuals. If the empirical EII value is significantly greater than the distribution,
then the empirical data cannot be described by the population structure -- significant information is lost when
collapsing across to the population structure.
}
\examples{
# Obtain simulated data
sim.data <- sim.dynEGA

\dontrun{
# Dynamic EGA individual and population structures
dyn1 <- dynEGA.ind.pop(
  data = sim.dynEGA[,-26], n.embed = 5, tau = 1,
  delta = 1, id = 25, use.derivatives = 1,
  model = "glasso", ncores = 2, corr = "pearson"
)

# Empirical Ergodicity Information Index
eii1 <- ergoInfo(dynEGA.object = dyn1, use = "weighted")

# Bootstrap Test for Ergodicity Information Index
testing.ergoinfo <- boot.ergoInfo(
  dynEGA.object = dyn1, EII = eii1,
  ncores = 2
)}

}
\references{
Golino, H., Nesselroade, J., & Christensen, A. P. (2022).
Toward a psychology of individuals: The ergodicity information index and a bottom-up approach for finding generalizations.
\emph{PsyArXiv}.
}
\author{
Hudson Golino <hfg9s at virginia.edu> & Alexander P. Christensen <alexander.christensen at Vanderbilt.Edu>
}
