% Generated by roxygen2 (4.0.2): do not edit by hand
\name{populateDaily}
\alias{populateDaily}
\title{Populate Daily data frame}
\usage{
populateDaily(rawData, qConvert, interactive = TRUE)
}
\arguments{
\item{rawData}{dataframe contains at least dateTime, value, code columns}

\item{qConvert}{character conversion to cubic meters per second}

\item{interactive}{logical Option for interactive mode.  If true, there is user interaction for error handling and data checks.}
}
\value{
dataframe Daily
}
\description{
Using raw data that has at least dateTime, value, code, populates the rest of the basic Daily data frame used in WRTDS
}
\examples{
dateTime <- as.character(seq(as.Date("2001/1/1"),
         as.Date("2001/12/31"), by = "day"))
value <- 1:365
code <- rep("",365)
dataInput <- data.frame(dateTime, value, code, stringsAsFactors=FALSE)
Daily <- populateDaily(dataInput, 2)
}
\author{
Robert M. Hirsch \email{rhirsch@usgs.gov}
}
\keyword{WRTDS}
\keyword{flow}

