% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/plotFlowSingle.R
\name{plotFlowSingle}
\alias{plotFlowSingle}
\title{Creates a plot of a time series of a particular flow statistic and a lowess smooth of that flow statistic}
\usage{
plotFlowSingle(eList, istat, yearStart = NA, yearEnd = NA, qMax = NA,
  printTitle = TRUE, tinyPlot = FALSE, customPar = FALSE,
  runoff = FALSE, qUnit = 1, printStaName = TRUE, printPA = TRUE,
  printIstat = TRUE, cex = 0.8, cex.axis = 1.1, cex.main = 1.1,
  lwd = 2, col = "black", ...)
}
\arguments{
\item{eList}{named list with at least the Daily and INFO dataframes}

\item{istat}{A numeric value for the flow statistic to be graphed (possible values are 1 through 8)}

\item{yearStart}{A numeric value for year in which the graph should start, default is NA, which indicates that the graph should start with first annual value}

\item{yearEnd}{A numeric value for year in which the graph should end, default is NA, which indicates that the graph should end with last annual value}

\item{qMax}{A numeric value for the maximum value to be used for y-axis of graph, default is NA means that graph is self-scaling}

\item{printTitle}{logical variable, if TRUE title is printed, if FALSE title is not printed, default is TRUE}

\item{tinyPlot}{logical variable, if TRUE plot is designed to be plotted small, as a part of a multipart figure, default is FALSE}

\item{customPar}{logical defaults to FALSE. If TRUE, par() should be set by user before calling this function
(for example, adjusting margins with par(mar=c(5,5,5,5))). If customPar FALSE, EGRET chooses the best margins depending on tinyPlot.}

\item{runoff}{logical variable, if TRUE the streamflow data are converted to runoff values in mm/day}

\item{qUnit}{object of qUnit class \code{\link{printqUnitCheatSheet}}, or numeric represented the short code, or character representing the descriptive name.}

\item{printStaName}{logical variable, if TRUE station name is printed in title, if FALSE not printed, default is TRUE}

\item{printPA}{logical variable, if TRUE Period of Analysis information is printed in title, if FALSE not printed, default is TRUE}

\item{printIstat}{logical variable, if TRUE print the statistic name is printed in title, if FALSE not printed, default is TRUE}

\item{cex}{numerical value giving the amount by which plotting symbols should be magnified}

\item{cex.axis}{magnification to be used for axis annotation relative to the current setting of cex}

\item{cex.main}{magnification to be used for main titles relative to the current setting of cex}

\item{lwd}{number line width}

\item{col}{color of points on plot, see ?par 'Color Specification'}

\item{\dots}{arbitrary graphical parameters that will be passed to genericEGRETDotPlot function (see ?par for options)}
}
\description{
A part of the flowHistory system.
The index of the flow statistics is istat.  These statistics are:
(1) 1-day minimum, (2) 7-day minimum, (3) 30-day minimum, (4) median
(5) mean, (6) 30-day maximum, (7) 7-day maximum, and (8) 1-day maximum

Although there are a lot of optional arguments to this function, most are set to a logical default.

Data come from named list, which contains a Daily dataframe with the daily flow data,
and an INFO dataframe with metadata.
}
\examples{
eList <- Choptank_eList
# Water year:
plotFlowSingle(eList, 1)
# Graphs consisting of Jun-Aug
eList <- setPA(eList, paStart=6,paLong=3)
plotFlowSingle(eList, 1)
}
\seealso{
\code{\link{makeAnnualSeries}}, \code{\link{genericEGRETDotPlot}}
}
\keyword{graphics}
\keyword{statistics}
\keyword{streamflow}

