% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flexFN.R
\name{flexPlotAddOn}
\alias{flexPlotAddOn}
\title{Flexible Flow Normalization Plot Add On}
\usage{
flexPlotAddOn(eList, showArrows = TRUE, showRect = TRUE,
  customPalette = NULL)
}
\arguments{
\item{eList}{named list with at least the Daily, Sample, and INFO dataframes}

\item{showArrows}{logical whether or not to show arrows representing flow segments}

\item{showRect}{logical whether or not to show rectangles representing sample segments}

\item{customPalette}{character vector of colors as a hexadecimal string of the form "#rrggbb". 
Defaults to NULL, which indicates the use of a default palette (up to 21 segments).}
}
\description{
Flexible Flow Normalization Plot Add On
}
\examples{
eList <- Choptank_eList
eList <- setUpEstimation(eList)
flowNormStart <- c("1979-10-01","1990-01-01","1992-10-10")
flowNormEnd <- c("1995-06-06","2004-03-03","2011-09-29")
flowStart <- c("1979-10-01","1995-06-07","2004-03-04")
flowEnd <- c("1995-06-06","2004-03-03","2011-09-29") 
dateInfo <- data.frame(flowNormStart,
                       flowNormEnd,
                       flowStart, 
                       flowEnd, 
                       stringsAsFactors = FALSE)
\dontrun{
newEList <- flexFN(eList, dateInfo)
plotFluxHist(newEList)
flexPlotAddOn(newEList)

plotFluxHist(newEList)
flexPlotAddOn(newEList, customPalette=c("#d5ce48", "#fd300f", "#3e0289"))
}
}
