% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estCrossVal.R
\name{estCrossVal}
\alias{estCrossVal}
\title{Jack-Knife cross validation of the WRTDS (Weighted Regressions on Time, Discharge, and Season)}
\usage{
estCrossVal(DecLow, DecHigh, Sample, windowY = 7, windowQ = 2,
  windowS = 0.5, minNumObs = 100, minNumUncen = 50, edgeAdjust = TRUE,
  verbose = TRUE)
}
\arguments{
\item{DecLow}{number specifying minimum decimal year}

\item{DecHigh}{number specifying maximum decimal year}

\item{Sample}{data frame containing the sample values, default is Sample}

\item{windowY}{numeric specifying the half-window width in the time dimension, in units of years, default is 7}

\item{windowQ}{numeric specifying the half-window width in the discharge dimension, units are natural log units, default is 2}

\item{windowS}{numeric specifying the half-window with in the seasonal dimension, in units of years, default is 0.5}

\item{minNumObs}{numeric specifying the miniumum number of observations required to run the weighted regression, default is 100}

\item{minNumUncen}{numeric specifying the minimum number of uncensored observations to run the weighted regression, default is 50}

\item{edgeAdjust}{logical specifying whether to use the modified method for calculating the windows at the edge of the record.  The modified method tends to reduce curvature near the start and end of record.  Default is TRUE.}

\item{verbose}{logical specifying whether or not to display progress message}
}
\value{
SampleCrossV data frame containing the sample data augmented by the results of the cross-validation exercise
}
\description{
This function fits the WRTDS model n times (where n is the number of observations).  
For each fit, the data value being estimated is eliminated from the record. 
This gives predictions that do not depend on knowing the actual result for that day. 
Thus it provides for a more "honest" estimate of model performance than a traditional 
error analysis that uses all the data.
}
\examples{
eList <- Choptank_eList
Sample <- getSample(eList)
Daily <- getDaily(eList)
numDays <- length(Daily$DecYear)
DecLow <- Daily$DecYear[1]
DecHigh <- Daily$DecYear[numDays]
\donttest{
SampleCrossV <- estCrossVal(DecLow,DecHigh,Sample)
}
}
\keyword{statistics}
\keyword{water-quality}
